import java.net.*;
import java.io.*;

/** Uproszczony sposób tworzenia obiektów BufferedReaders i
 *  PrintWriters związanych z Socketem.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class SocketUtil {
  /** Tworzy BufferedReader odczytujący przychodzące dane. */
  
  public static BufferedReader getReader(Socket s)
      throws IOException {
    return(new BufferedReader(
         new InputStreamReader(s.getInputStream())));
  }

  /** Tworzy PrintWriter do wysyłania danych.
   *  Ten PrintWriter będzie automatycznie opróżniał bufor
   *  gdy wywołana będzie metoda println.
   */
  
  public static PrintWriter getWriter(Socket s)
      throws IOException {
    // drugi argument o wartości true oznacza automatyczne opróżnianie bufora
    return(new PrintWriter(s.getOutputStream(), true));
  }
}
