import java.net.*;
import java.io.*;

/** Klasa bazowa używana przy tworzeniu serwerów sieciowych.
 *  Należy przesłonić metodę handleConnection, jednak w wielu
 *  przypadkach metoda listen może pozostać w niezmienionej
 *  postaci. Klasa NetworkServer używa klasy SocketUtil
 *  aby uprościć sobie zadanie tworzenia egzemplarzy obiektów
 *  PrintWriter oraz BufferedReader.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall & Larry Brown; można kopiować i modyfikować bez ograniczeń.
 */

public class NetworkServer {
  private int port, maxConnections;

  /** Tworzy serwer pracujący na podanym porcie. Serwer będzie
   *  przyjmował połączenia, przekazując każde z nich do 
   *  metody handleConnection, aż do momentu otrzymania 
   *  jawnego polecenia przerwania pracy (na przykład: 
   *  System.exit) lub przekroczenia liczby dopuszczalnych
   *  połączeń. Jeśli chcesz, aby serwer działał w nieskończoność
   *  to jako maxConnections podaj wartość 0.
   */

  public NetworkServer(int port, int maxConnections) {
    setPort(port);
    setMaxConnections(maxConnections);
  }

  /** Monitoruje port na który będą przesyłane prośby
   *  o połączenie z serwerem. Za każdym razem gdy 
   *  połączenie zostanie nawiązane, uzyskany egzemplarz
   *  obiektu klasy Socket jest przekazywany do metody
   *  handleConnection.
   */

  public void listen() {
    int i=0;
    try {
      ServerSocket listener = new ServerSocket(port);
      Socket server;
      while((i++ < maxConnections) || (maxConnections == 0)) {
        server = listener.accept();
        handleConnection(server);
      }
    } catch (IOException ioe) {
      System.out.println("IOException: " + ioe);
      ioe.printStackTrace();
    }
  }

  /** To jest metoda definiująca sposób działania 
   *  serwera, gdyż określa ona co się dzieje z wynikowym
   *  gniazdem (egzemplarzem obiektu klasy Socket).
   *  <B>W serwerach, które będziesz pisać, powinieneś
   *  przesłonić tę metodę</B>.
   *  <P>
   *  Ta ogólna wersja metody określa komputer, który
   *  nadesłał żądanie, wyświetla pierwszy wiersz żądania
   *  nadesłany przez klienta i generuje pierwszy wiersz
   *  odpowiedzi HTTP.
   */

  protected void handleConnection(Socket server)
      throws IOException{
    BufferedReader in = SocketUtil.getReader(server);
    PrintWriter out = SocketUtil.getWriter(server);
    System.out.println
      ("Ogólny serwer sieciowy: odebrano połączenie z " +
       server.getInetAddress().getHostName() + "\n" +
       "pierwszy wiersz żądania '" + in.readLine() + "'");
    out.println("Ogólny serwer sieciowy");
    server.close();
  }

  /** Zwraca maksymalną liczbę połączeń, jaka zostanie 
   *  obsłużona zanim serwer przestanie działać.
   *  Wartość 0 oznacza, że serwer powinien działać aż
   *  do momentu gdy jawnie zostanie zamknięty.
   */

  public int getMaxConnections() {
    return(maxConnections);
  }

  /** Określa maksymalną liczbę połączeń. Wartość 0 oznacza
   *  że serwer powinien działać w nieskończoność (aż do
   *  momentu gdy zostanie jawnie zamknięty).
   */

  public void setMaxConnections(int maxConnections) {
    this.maxConnections = maxConnections;
  }

  /** Zwraca numer portu, na którym działa serwer. */
  
  public int getPort() {
    return(port);
  }

  /** Określa numer portu. <B>Port można określić wyłącznie 
   *  przed wywołaniem metody "connect"</B>. Zazwyczaj port
   *  jest określany w konstruktorze.
   */

  protected void setPort(int port) {
    this.port = port;
  }
}    