package coreservlets;

import java.util.*;

/** Klasa implementująca koszyk - jest to struktura danych
 *  służąca do przechowywania informacji o zamawianych 
 *  produktach. 
 *  Serwlet OrderPage kojarzy jeden z tych koszyków
 *  z każdą sesją.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */
 
public class ShoppingCart {
  private ArrayList itemsOrdered;

  /** Twórz pusty koszyk */
    
  public ShoppingCart() {
    itemsOrdered = new ArrayList();
  }

  /** Zwraca listę zawierającą obiekty 
   *  ItemOrder określające produkt oraz jego 
   *  zamówioną ilość. Zadeklarowana jako List a nie
   *  ListArray, aby później można było łatwo 
   *  zmieniać implementację.
   */
  
  public List getItemsOrdered() {
    return(itemsOrdered);
  }

  /** Przegląda koszyk i sprawdza, czy znajduje się już
   *  w nim zamówienie dotyczące produktu o podanym 
   *  identyfikatorze. Jeśli takie zamówienie zostanie odnalezione
   *  liczba egzemplarzy danego produktu jest inkrementowana.
   *  Jeśli nie ma zamówienia dotyczącego podanego produktu,
   *  to metoda pobiera z katalogu (Catalog) informacje o nim
   *  i dodaje do koszyka odpowiedni obiekt.
   */
  
  public synchronized void addItem(String itemID) {
    ItemOrder order;
    for(int i=0; i<itemsOrdered.size(); i++) {
      order = (ItemOrder)itemsOrdered.get(i);
      if (order.getItemID().equals(itemID)) {
        order.incrementNumItems();
        return;
      }
    }
    ItemOrder newOrder = new ItemOrder(Catalog.getItem(itemID));
    itemsOrdered.add(newOrder);
  }

  /** Przegląda koszyk w poszukiwaniu wpisu dotyczącego 
   *  produktu o podanym identyfikatorze. Jeśli podana liczba
   *  numOrdered jest większa od zera, określa ona
   *  liczby zamówionych egzemplarzy danego produktu. Jeśli 
   *  przekazana liczba ma wartość 0 (lub mniejszą od zera,
   *  co może nastąpić w przypadku błędu użytkownika),
   *  wpis reprezentujący dany produkt jest usuwany z koszyka.
   */
  
  public synchronized void setNumOrdered(String itemID,
                                         int numOrdered) {
    ItemOrder order;
    for(int i=0; i<itemsOrdered.size(); i++) {
      order = (ItemOrder)itemsOrdered.get(i);
      if (order.getItemID().equals(itemID)) {
        if (numOrdered <= 0) {
          itemsOrdered.remove(i);
        } else {
          order.setNumItems(numOrdered);
        }
        return;
      }
    }
    ItemOrder newOrder =
      new ItemOrder(Catalog.getItem(itemID));
    itemsOrdered.add(newOrder);
  }
}
    
