package coreservlets;

/** Katalog zawierający informacje o produktach 
 *  dostępnych w internetowym sklepie.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class Catalog {
  // Normalnie te informacje byłyby przechowywane i pobierane
  // z bazy danych.
  // W tym przykładzie użyto zwyczajnej tablicy by zapewnić
  // łatwość testowania i wdrażania.
  // Informacje dotyczące zastosowania baz danych w serwletach
  // i stronach JSP można znaleźć w rozdziałach poświęconych
  // JDBC.
  private static CatalogItem[] items =
    { new CatalogItem
      ("hall001",
       "<I>Java Servlets i Java Server Pages</I> " +
         " autor Marty Hall",
       "Doskonała pozycja wydawnictwa HELION poświęcona " +
         "serwletom i JSP.\n" +
         "Nominowana do nagrody Nobla w dziedzinie literatury.",
       39.95),
      new CatalogItem
        ("hall002",
         "<I>Core Web Programming, Java2 Edition</I> " +
           " autorzy: Marty Hall, Larry Brown oraz " +
           "Paul McNamee",
         "Wspaniała książka dla programistów aplikacji " +
           "internetowych. Omawiane w niej zagadnienia obejmują \n" +
           "<UL><LI>dokładną prezentację platformy Java 2; " +
           "w tym wątków, zagadnień sieciowych, pakietu Swing, \n" +
           "Java2D oraz kolekcji,\n" +
           "<LI>krótkie wprowadzenie do HTML 4.01, " +
           "zawierające prezentację układów ramek, arkuszy stylów, \n" +
           "warstw oraz rozszerzeń Netscape Navigator i " +
           "Internet Explorer,\n" +
           "<LI>krótkie wprowadzenie do protokołu HTTP 1.1, " +
           "serwletów i Java Server Pages,\n" +
           "<LI>krótkie omówienie języka JavaScript 1.2\n" +
           "</UL>",
         49.99),
      new CatalogItem
        ("lewis001",
         "<I>Opowieści z Narnii</I> autor: C.S. Lewis",
         "Klasyczna dziecięca powieść przygodowa; zmagania " +
           "Aslana Wielkiego Lwa i jego towarzyszy\n" +
           "z Białą Wiedźmą oraz siłami zła." +
           "Smoki, czarodzieje, trudne zadania \n" +
           "i mówiące zwierzęta tworzą głęboką duchową " +
           "alegorię. Seria obejmuje książki\n" +
           "<I>Siostrzeniec czarodzieja</I>,\n" +
           "<I>Lew, Wiedźma i stara szafa</I>,\n" +
           "<I>Koń i jego chłopiec</I>,\n" +
           "<I>Książę Kaspian</I>,\n" +
           "<I>Podróż \"Wędrowca do Świtu\"</I>,\n" +
           "<I>Srebrne krzesło</I> oraz \n" +
           "<I>Ostatnia bitwa</I>.",
         19.95),
      new CatalogItem
        ("alexander001",
         "<I>Historia Prydain</I> autor: Lloyd Alexander",
         "Taran, pokorny hodowca świń, przyłącza się do " +
           "potężnego Lorda Gwydiona i towarzyszy w mu w \n" +
           "bitwie przeciwko Arawnowi - Lordowi Annuvin. Wraz " +
           "z wiernymi przyjaciółmi oraz piękną księżniczką \n" +
           "Eilonwy, niedoszłym bardem Fflewddurem Fflamem, " +
           "i futrzastym półczłowiekiem Gurgi, Taran odkrywa " +
           "czym jest odwaga, honor oraz inne wartości.\n" +
           "Seria obejmuje następujące książki: \n" +
           "<I>Księga trzech</I>, \n" +
           "<I>Czarny kocioł</I>, \n" +
           "<I>Zamek Llyr</I>, \n" +
           "<I>Taran Wędrowiec</I> oraz \n" +
           "<I>Wielki król</I>.",
         19.95),
      new CatalogItem
        ("rowling001",
         "<I>Trylogia o Harrym Potterze</I> autorka: " +
           "J.K. Rowling",
         "Pierwsze trzy książki niezwykle popularniej serii o " +
           "początkującym czarodzieju Harrym Potterze \n" +
           "szybko trafiły na szczyt list bestsellerów " +
           "zarówno dla dzieci jak i dla dorosłych. Seria \n" +
           "obejmuje książki: \n" +
           "<I>Harry Potter i kamień filozoficzny</I>, \n" +
           "<I>Harry Potter i komnata tajemnic</I>, \n" +
           "<I>Harry Potter i więzień Azkabanu</I>, " +
           "<I>Harry Potter i Czara Ognia</I> oraz\n" +
           "<I>Harry Potter i Zakon Faniksa</I>.\n",
         59.95)
        };

  public static CatalogItem getItem(String itemID) {
    CatalogItem item;
    if (itemID == null) {
      return(null);
    }
    for(int i=0; i<items.length; i++) {
      item = items[i];
      if (itemID.equals(item.getItemID())) {
        return(item);
      }
    }
    return(null);
  }
}
               
