package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Serwlet przetwarzający informacje podane przez użytkownika
 *  w formularzu rejestracyjnym (czyli: imię, nazwisko 
 *  i adres email). Jeśli wszystkie informacje zostały 
 *  podane, serwlet wyświetla ich wartości. Jeśli którakolwiek
 *  z danych została pominięta, serwlet ponownie wyświetla 
 *  formularz. W obu przypadkach przesłane wartości są
 *  umieszczane w cookies, tak by można je było ponownie 
 *  wyświetlić w polach formularza.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class RegistrationServlet extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html; charset=ISO-8859-2");
    boolean isMissingValue = false;
    String firstName = request.getParameter("firstName");
    if (isMissing(firstName)) {
      firstName = "Nie podano imienia";
      isMissingValue = true;
    }
    String lastName = request.getParameter("lastName");
    if (isMissing(lastName)) {
      lastName = "Nie podano nazwiska";
      isMissingValue = true;
    }
    String emailAddress = request.getParameter("emailAddress");
    if (isMissing(emailAddress)) {
      emailAddress = "Nie podano adresu email";
      isMissingValue = true;
    }
    Cookie c1 = new LongLivedCookie("firstName", firstName);
    response.addCookie(c1);
    Cookie c2 = new LongLivedCookie("lastName", lastName);
    response.addCookie(c2);
    Cookie c3 = new LongLivedCookie("emailAddress",
                                    emailAddress);
    response.addCookie(c3);
    String formAddress =
      "/servlet/coreservlets.RegistrationForm";
    if (isMissingValue) {
      response.sendRedirect(formAddress);
    } else {
      PrintWriter out = response.getWriter();
      String docType =
        "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
        "Transitional//EN\">\n";
      String title = "Dziękuję za rejestrację";
      out.println
        (docType +
         "<HTML>\n" +
         "<HEAD><TITLE>" + title + "</TITLE></HEAD>\n" +
         "<BODY BGCOLOR=\"#FDF5E6\">\n" +
         "<CENTER>\n" +
         "<H1 ALIGN>" + title + "</H1>\n" +
         "<UL>\n" +
         "  <LI><B>Imię</B>: " +
                firstName + "\n" +
         "  <LI><B>Nazwisko</B>: " +
                lastName + "\n" +
         "  <LI><B>Adres email</B>: " +
                emailAddress + "\n" +
         "</UL>\n" +
         "</CENTER></BODY></HTML>");
    }
  }

  /** Metoda określa czy wartość jest równa null bądź 
   *  czy jest pustym łańcuchem znaków. 
   */
  
  private boolean isMissing(String param) {
    return((param == null) ||
           (param.trim().equals("")));
  }
}
