package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Serwlet generuje tabelę przedstawiającą cookies
 *  skojarzone z bieżącą stroną. Oprócz tego, 
 *	serwlet tworzy sześć cookies: trzy cookies 
 *	sesyjne (które będą ważne do zakończenia 
 *  bieżącej sesji przeglądarki niezależnie do teg
 *  jak długo będzie ona trwała) oraz trzy cookies
 *	trwałe, które będą ważne przez godzinę 
 *	(niezależnie od tego czy przeglądarka zostanie 
 *	w międzyczasie zamknięta).
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class CookieTest extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    for(int i=0; i<3; i++) {
      // domyślny maksymalny okres ważność cookie 
      // ma wartość -1, co oznacza, że dane cookie
      // będzie ważne jedynie podczas danej sesji przeglądarki
      Cookie cookie = new Cookie("Session-Cookie-" + i,
                                 "Cookie-Value-S" + i);
      response.addCookie(cookie);
      cookie = new Cookie("Persistent-Cookie-" + i,
                          "Cookie-Value-P" + i);
      // Cookie będzie ważne przez godzinę, niezależnie od
      // tego czy użytkownik zamknie przeglądarkę, ponownie
      // uruchomi komputer albo wykona inne dziwne czynności
      cookie.setMaxAge(3600);
      response.addCookie(cookie);
    } 
    response.setContentType("text/html; charset=ISO-8859-2");
    PrintWriter out = response.getWriter();
    String docType =
      "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
      "Transitional//EN\">\n";
    String title = "Aktywne cookies";
    out.println(docType +
                "<HTML>\n" +
                "<HEAD><TITLE>" + title + "</TITLE></HEAD>\n" +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H1 ALIGN=\"CENTER\">" + title + "</H1>\n" +
                "<TABLE BORDER=1 ALIGN=\"CENTER\">\n" +
                "<TR BGCOLOR=\"#FFAD00\">\n" +
                "  <TH>Nazwa cookie</TH>\n" +
                "  <TH>Wartość cookie</TH>\n" +
                "</TR>\n");
    Cookie[] cookies = request.getCookies();
    if (cookies == null) {
      out.println("<TR><TH COLSPAN=2>Brak cookies</TH></TR>");
    } else {
      Cookie cookie;
      for(int i=0; i<cookies.length; i++) {
        cookie = cookies[i];
        out.println("<TR>\n" +
                    "  <TD>" + cookie.getName() + "</TD>\n" +
                    "  <TD>" + cookie.getValue() + "</TD>\n" +
                    "</TR>\n");
      }
    }
    out.println("</TABLE></BODY></HTML>");
  }
}
