package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

/** Serwlet obsługujący przeglądanie i przechowywanie 
 *  życiorysów przesyłanych przez osoby poszukujące pracy.
 */

public class SubmitResume extends HttpServlet {
  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html; charset=ISO-8859-2");
    PrintWriter out = response.getWriter();
    if (request.getParameter("previewButton") != null) {
      showPreview(request, out);
    } else {
      storeResume(request);
      showConfirmation(request, out);
    }
  }

  /* Wyświetla podgląd nadesłanego życiorysu. Pobiera
   * informacje o czcionce i na jego podstawie tworzy 
   * arkusz stylów; następnie pobiera informacje
   * życiorysu i prezentuje je na stronie. Wygląd 
   * prezentowanych informacji określa arkusz stylów.
   */ 
  
  private void showPreview(HttpServletRequest request, PrintWriter out) 
    throws UnsupportedEncodingException
  {
    String headingFont = request.getParameter("headingFont");
    headingFont = replaceIfMissingOrDefault(headingFont, "");
    int headingSize =
      getSize(request.getParameter("headingSize"), 32);
    String bodyFont = request.getParameter("bodyFont");
    bodyFont = replaceIfMissingOrDefault(bodyFont, "");
    int bodySize =
      getSize(request.getParameter("bodySize"), 18);
    String fgColor = request.getParameter("fgColor");
    fgColor = replaceIfMissing(fgColor, "BLACK");
    String bgColor = request.getParameter("bgColor");
    bgColor = replaceIfMissing(bgColor, "WHITE");
    String name = 
        new String(request.getParameter("name").getBytes("ISO-8859-1"), 
        "ISO-8859-2");
    name = replaceIfMissing(name, "Lou Zer");
    String title = 
        new String(request.getParameter("title").getBytes("ISO-8859-1"), 
        "ISO-8859-2");
    title = replaceIfMissing(title, "ob.");
    String email = request.getParameter("email");
    email =
      replaceIfMissing(email, "contact@superfucha.com");
    String languages = request.getParameter("languages");
    languages = replaceIfMissing(languages, "<I>Brak</I>");
    String languageList = makeList(languages);
    String skills = 
        new String(request.getParameter("skills").getBytes("ISO-8859-1"), 
        "ISO-8859-2");
    skills = replaceIfMissing(skills, "Niewiele.");
    out.println
      (ServletUtilities.DOCTYPE + "\n" +
       "<HTML>\n" +
       "<HEAD>\n" +
       "<TITLE>Życiorys - " + name + "</TITLE>\n" +
       makeStyleSheet(headingFont, headingSize,
                      bodyFont, bodySize,
                      fgColor, bgColor) + "\n" +
       "</HEAD>\n" +
       "<BODY>\n" +
       "<CENTER>\n"+
       "<SPAN CLASS=\"HEADING1\">" + name + "</SPAN><BR>\n" +
       "<SPAN CLASS=\"HEADING2\">" + title + "<BR>\n" +
       "<A HREF=\"mailto:" + email + "\">" + email +
           "</A></SPAN>\n" +
       "</CENTER><BR><BR>\n" +
       "<SPAN CLASS=\"HEADING3\">Języki programowania" +
       "</SPAN>\n" +
       languageList + "<BR><BR>\n" +
       "<SPAN CLASS=\"HEADING3\">Umiejętności i doświadczenia" +
       "</SPAN><BR><BR>\n" +
       skills + "\n" +
       "</BODY></HTML>");
  }

  /* Metoda tworzy kaskadowy arkusz stylów zawierający informacje
   * o trzech poziomach nagłówków oraz kolorze tła i tekstu.
   * W przypadku Internet Explorera kolor połączenia mailto 
   * jest zmieniany po umieszczeniu na nim wskaźnika myszy.
   */
  
  private String makeStyleSheet(String headingFont,
                                int heading1Size,
                                String bodyFont,
                                int bodySize,
                                String fgColor,
                                String bgColor) {
    int heading2Size = heading1Size*7/10;
    int heading3Size = heading1Size*6/10;
    String styleSheet =
      "<STYLE TYPE=\"text/css\">\n" +
      "<!--\n" +
      ".HEADING1 { font-size: " + heading1Size + "px;\n" +
      "            font-weight: bold;\n" +
      "            font-family: " + headingFont +
                     "Arial, Helvetica, sans-serif;\n" +
      "}\n" +
      ".HEADING2 { font-size: " + heading2Size + "px;\n" +
      "            font-weight: bold;\n" +
      "            font-family: " + headingFont +
                     "Arial, Helvetica, sans-serif;\n" +
      "}\n" +
      ".HEADING3 { font-size: " + heading3Size + "px;\n" +
      "            font-weight: bold;\n" +
      "            font-family: " + headingFont +
                     "Arial, Helvetica, sans-serif;\n" +
      "}\n" +
      "BODY { color: " + fgColor + ";\n" +
      "       background-color: " + bgColor + ";\n" +
      "       font-size: " + bodySize + "px;\n" +
      "       font-family: " + bodyFont +
                    "Times New Roman, Times, serif;\n" +
      "}\n" +
      "A:hover { color: red; }\n" +
      "-->\n" +
      "</STYLE>";
    return(styleSheet);
  }

  /* Zastępuje nieistnijące (null) łańcuchy znaków 
   * (gdy parametr nie został podany) oraz puste łańcuchy
   * znaków (w polu tekstowym niczego nie wpisano) 
   * podaną wartością domyślną. W przeciwnym razie zwraca
   * oryginalny łańcuch znaków.
   */
  
  private String replaceIfMissing(String orig,
                                  String replacement) {
    if ((orig == null) || (orig.trim().equals(""))) {
      return(replacement);
    } else {
      return(orig);
    }
  }

  /* Zastępuje nieistniejące (null) łańcuchy znaków, puste
   * łańcuchy oraz łańcuch o wartości "default" podanym
   * zamiennikiem. W przeciwnym razie zwraca oryginalny
   * łańcuch znaków.
   */
  
  private String replaceIfMissingOrDefault(String orig,
                                           String replacement) {
    if ((orig == null) ||
        (orig.trim().equals("")) ||
        (orig.equals("default"))) {
      return(replacement);
    } else {
      return(orig + ", ");
    }
  }

  /* Pobiera wartość całkowitą zapisaną w formie łańcucha
   * znaków i zwraca ją w formie liczby całkowitej. Jeśli
   * łańcuch znaków wynosi null lub został zapisany w 
   * niewłaściwym formacie, zwracana jest wartość domyślna.
   */
    
  private int getSize(String sizeString, int defaultSize) {
    try {
      return(Integer.parseInt(sizeString));
    } catch(NumberFormatException nfe) {
      return(defaultSize);
    }
  }

  /* Łańcuch wejściowy "Java,C++,Lisp", "Java C++ Lisp" lub
   * "Java, C++, Lisp", powoduje wygenerowanie kodu HTML:
   * "<UL>
   *   <LI>Java
   *   <LI>C++
   *   <LI>Lisp
   *  </UL>"
   */

  private String makeList(String listItems) {
    StringTokenizer tokenizer =
      new StringTokenizer(listItems, ", ");
    String list = "<UL>\n";
    while(tokenizer.hasMoreTokens()) {
      list = list + "  <LI>" + tokenizer.nextToken() + "\n";
    }
    list = list + "</UL>";
    return(list);
  }

  /* Wyświetla stronę potwierdzenia, gdy zostanie 
   * kliknięty przycisk "Prześlij".
   */
  
  private void showConfirmation(HttpServletRequest request,
                                PrintWriter out) {
    String title = "Życiorys przyjęty.";
    out.println(ServletUtilities.headWithTitle(title) +
                "<BODY>\n" +
                "<H1>" + title + "</H1>\n" +
                "Twój życiorys powinien się pojawić na WWW\n" +
                "w ciągu 24 godzin. Jeśli się nie pojawi, \n" +
                "to spróbuj go przesłać ponownie podając inny\n" +
                "adres poczty elektronicznej.\n" + 
                "</BODY></HTML>");
  }

  /* Dlaczego nie należy przesyłać swojego adresu poczty
   * elektronicznej witrynom, którym nie wiadomo, czy można 
   * zaufać.
   */
  
  private void storeResume(HttpServletRequest request) {
    String email = request.getParameter("email");
    putInSpamList(email);
  }
  
  private void putInSpamList(String emailAddress) {
    // Na wszelki wypadek usunąłem ten kod.
  }
}
