/* Zmniejsza ceny pyt z utworami kompozytora okrelonego
 * przy uyciu parametru composer_in. Ceny s zmniejszane 
 * o warto okrelon parametrem discount_in.
 *
 * Funkcja zwraca ilo zmodyfikowanych wierszy, lub 
 * warto -1 w przypadku podanie niewaciwej wielkoci
 * zniki.
 *
 * Taken from Core Servlets and JavaServer Pages 2nd Edition
 * from Prentice Hall and Sun Microsystems Press,
 * http://www.coreservlets.com/.
 * &copy; 2003 Marty Hall and Larry Brown.
 * May be freely used or adapted.
 */

CREATE OR REPLACE FUNCTION discount
  (composer_in IN VARCHAR2, discount_in IN NUMBER)
RETURN NUMBER
IS
  min_discount CONSTANT NUMBER:= 0.05;
  max_discount CONSTANT NUMBER:= 0.50;
BEGIN
  IF discount_in BETWEEN min_discount AND max_discount THEN
    UPDATE music
    SET price = price * (1.0 - discount_in)
    WHERE composer = composer_in;
    RETURN(SQL%ROWCOUNT);
  ELSE
    RETURN(-1);
  END IF;
END discount;