package coreservlets.jdo;

import java.util.*;
import java.io.*;
import javax.jdo.*;

/** Zapisanie danych w tabeli 'music' przy użyciu JDO.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall & Larry Brown; można kopiować i modyfikować bez ograniczeń.
 */
 
public class PopulateMusicTable {
  public static void main(String[] args) {
    // Utworzenie siedmiu nowych obiektów Music, które zostaną
    // zapisane w bazie danych.
    Music[] objects = {
      new Music(1, "Mozart", "Nr. 21 cis-moll", 7, 24.99F),
      new Music(2, "Beethoven", "Nr. 3 c-moll", 28, 10.99F),
      new Music(3, "Beethoven", "Nr. 5 Es-dur", 33, 10.99F),
      new Music(4, "Rachmaninov", "Nr. 2 c-moll", 9, 18.99F),
      new Music(5, "Mozart", "Nr. 24 c-moll", 11, 21.99F),
      new Music(6, "Beethoven", "Nr. 4 G-dur", 33, 12.99F),
      new Music(7, "Liszt", "Nr. 1 Es-dur", 48, 10.99F)
    };
    
    // Wczytanie pliku właściwości z informacjami JDO. Plik ten 
    // zawiera informacje wymagane przez szkielet ORM, dotyczące
    // rodzaju bazy danych oraz sposobu nawiązania połączenia.
    Properties properties = new Properties();
    try {
      FileInputStream fis =
        new FileInputStream("jdo.properties");
      properties.load(fis);
    } catch(IOException ioe) {
      System.err.println("Nie udało się wczytać pliku właściwości: " +
                         ioe);
      return;
    }

    // Inicjalizacja menedżera trwałości.
    PersistenceManagerFactory pmf =
      JDOHelper.getPersistenceManagerFactory(properties);
    PersistenceManager pm = pmf.getPersistenceManager();

    // Zapis nowych obiektów Music w bazie danych.
    Transaction transaction = pm.currentTransaction();
    transaction.begin();
    pm.makePersistentAll(objects);
    transaction.commit();
    pm.close ();
  }
}    