package coreservlets;

import java.util.*;

/** Komponent reprezentujący klienta banku.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class BankCustomer {
  private String id, firstName, lastName;
  private double balance;

  public BankCustomer(String id,
                      String firstName,
                      String lastName,
                      double balance) {
    this.id = id;
    this.firstName = firstName;
    this.lastName = lastName;
    this.balance = balance;
  }

  public String getId() {
    return(id);
  }

  public String getFirstName() {
    return(firstName);
  }

  public String getLastName() {
    return(lastName);
  }

  public double getBalance() {
    return(balance);
  }

  public double getBalanceNoSign() {
    return(Math.abs(balance));
  }

  public void setBalance(double balance) {
    this.balance = balance;
  }

  // Tworzymy prostą tablicę klientów.
  
  private static HashMap customers;

  static {
    customers = new HashMap();
    customers.put("id001",
                  new BankCustomer("id001",
                                   "Witek",
                                   "Hacker",
                                   -3456.78));
    customers.put("id002",
                  new BankCustomer("id002",
                                   "Janka",
                                   "Hacker",
                                   1234.56));
    customers.put("id003",
                  new BankCustomer("id003",
                                   "Piotrek",
                                   "Hacker",
                                   987654.32));
  }

  /** Metoda odnajduje klienta banku o podanym identyfikatorze.
   *  Jeśli klient nie zostanie odnaleziony, zwracana jest 
   *  wartość null.
   */
  
  public static BankCustomer getCustomer(String id) {
    return((BankCustomer)customers.get(id));
  }
}
  
