package coreservlets;

import javax.servlet.http.*;

/** Cookie, które będzie istnieć dokładnie przez 1 rok.
 *  Cookies tworzone w domyślny sposób istnieją tylko
 *  do końca bieżącej sesji przeglądarki.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class LongLivedCookie extends Cookie {
  public static final int SECONDS_PER_YEAR = 60*60*24*365;
  
  public LongLivedCookie(String name, String value) {
    super(name, value);
    setMaxAge(SECONDS_PER_YEAR);
  }
}
