package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Klasa bazowa stron prezentujących produkty z katalogu.
 *  Serwlety dziedziczące po  tej klasie bazowej muszą
 *  określić wyświetlane elementy katalogu oraz tytuł
 *  strony <i>zanim</i> serwlet zostanie wykonany.
 *  W tym celu w metodzie init takiego serwletu należy
 *  wywołać metody setItems oraz setTitle klasy bazowej.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public abstract class CatalogPage extends HttpServlet {
  private CatalogItem[] items;
  private String[] itemIDs;
  private String title;

  /** Dysponując tablicą identyfikatorów produktów, odszukaj
   *  je w katalogu (klasa Catalog) i zapisz odpowiadające im
   *  obiekty CatalogItem do tablicy items. Obiekty 
   *  CatalogItem zawierają krótki opis, pełny opis oraz 
   *  cenę produktu, a ich unikalnym kluczem jest 
   *  identyfikator produktu.
   *  <P>
   *  Serwlety dziedziczące po klasie CatalogPage 
   *  <b>muszą</b> wywoływać tę metodę (zazwyczaj 
   *  w metodzie init) zanim serwlet zostanie wywołany.
   */

  protected void setItems(String[] itemIDs) {
    this.itemIDs = itemIDs;
    items = new CatalogItem[itemIDs.length];
    for(int i=0; i<items.length; i++) {
      items[i] = Catalog.getItem(itemIDs[i]);
    }
  }

  /** Określa tytuł strony, który jest wyświetlany na
   *  stronie wynikowej w nagłówku <H1>.
   *  <P>
   *  Serwlety dziedziczące po klasie CatalogPage 
   *  <b>muszą</b> wywoływać tę metodę (zazwyczaj 
   *  w metodzie init) zanim serwlet zostanie wywołany.
   */
  
  protected void setTitle(String title) {
    this.title = title;
  }

  /** Metoda w pierwszej kolejności wyświetla tytuł, a następnie
   *  dla każdego produktu z katalogu, który ma być przedstawiony
   *  na danej stronie, wyświetla jego krótki opis (w nagłówku
   *  <H2>), cenę (w nawiasach) oraz pełny opis poniżej.
   *  Poniżej opisu każdego produktu wyświetlany jest przycisk umożliwiający
   *  złożenie zamówienia dotyczącego danego produktu - informacje
   *  przesyłane są do serwletu OrderPage.
   *  <P>
   *  Aby zobaczyć kod HTML generowany przez tę metodę, należy
   *  wykonać serwlet KidsBooksPage lub TechBooksPage (obydwie 
   *  te klasy dziedziczą po abstrakcyjnej klasie CatalogPage)
   *  i wybrać opcję "Wyświetl kod źródłowy" (lub jej odpowiednik)
   *  w przeglądarce.
   */
  
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html; charset=ISO-8859-2");
    if (items == null) {
      response.sendError(HttpServletResponse.SC_NOT_FOUND,
                         "Brak produktów.");
      return;
    }
    PrintWriter out = response.getWriter();
    String docType =
      "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
      "Transitional//EN\">\n";
    out.println(docType +
                "<HTML>\n" +
                "<HEAD><TITLE>" + title + "</TITLE></HEAD>\n" +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H1 ALIGN=\"CENTER\">" + title + "</H1>");
    CatalogItem item;
    for(int i=0; i<items.length; i++) {
      out.println("<HR>");
      item = items[i];
      // Wyświetla informacje o błędzie, jeśli klasa potomna
      // podała identyfikator produktu, którego nie ma w katalogu
      if (item == null) {
        out.println("<FONT COLOR=\"RED\">" +
                    "Nieznany identyfikator produktu " + itemIDs[i] +
                    "</FONT>");
      } else {
        out.println();
        String formURL =
          "/servlet/coreservlets.OrderPage";
        // Adresy URL odwołujące się do tej samej witryny należy
        // przekształcać za pomocą metody encodeURL.
        formURL = response.encodeURL(formURL);
        out.println
          ("<FORM ACTION=\"" + formURL + "\">\n" +
           "<INPUT TYPE=\"HIDDEN\" NAME=\"itemID\" " +
           "       VALUE=\"" + item.getItemID() + "\">\n" +
           "<H2>" + item.getShortDescription() +
           " (" + item.getCost() + " zł)</H2>\n" +
           item.getLongDescription() + "\n" +
           "<P>\n<CENTER>\n" +
           "<INPUT TYPE=\"SUBMIT\" " +
           "VALUE=\"Dodaj do koszyka\">\n" +
           "</CENTER>\n<P>\n</FORM>");
      }
    }
    out.println("<HR>\n</BODY></HTML>");
  }
}
