package coreservlets;

import java.math.BigInteger;

/** Kilka pomocniczych narzędzi służących do generowania 
 *  dużych liczb losowych typu BigInteger i odnajdywania
 *  liczb pierwszych większych od podanej wartości 
 *  BigInteger.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class Primes {
  private static final BigInteger ZERO = BigInteger.ZERO;
  private static final BigInteger ONE = BigInteger.ONE;
  private static final BigInteger TWO = new BigInteger("2");
  
  // Prawdopodobieństwo popełnienia błędu przy określaniu,
  // czy dana liczba jest liczbą pierwszą, jest mniejsze
  // od 1/2^ERR_VAL. Klasa BigInteger w JDK 1.4
  // używa kombinacji algorytmów Millera-Rabina i Lucasa-Lehmera
  // i dlatego nie można jej oszukać stosując liczby 
  // Carmichaela. Więcej szczegółów znajduje się w rozdziale
  // 33.8 książki Introduction to Algorithms autorstwa Coremana
  // i in.
  
  private static final int ERR_VAL = 100;
  
  public static BigInteger nextPrime(BigInteger start) {
    if (isEven(start))
      start = start.add(ONE);
    else
      start = start.add(TWO);
    if (start.isProbablePrime(ERR_VAL))
      return(start);
    else
      return(nextPrime(start));
  }

  private static boolean isEven(BigInteger n) {
    return(n.mod(TWO).equals(ZERO));
  }

  private static StringBuffer[] digits =
    { new StringBuffer("0"), new StringBuffer("1"),
      new StringBuffer("2"), new StringBuffer("3"),
      new StringBuffer("4"), new StringBuffer("5"),
      new StringBuffer("6"), new StringBuffer("7"),
      new StringBuffer("8"), new StringBuffer("9") };

  private static StringBuffer randomDigit(boolean isZeroOK) {
    int index;
    if (isZeroOK) {
      index = (int)Math.floor(Math.random() * 10);
    } else {
      index = 1 + (int)Math.floor(Math.random() * 9);
    }
    return(digits[index]);
  }

  /** Metoda tworzy dużą liczbę całkowitą, 
   *  której wszystkie cyfry są wybierane losowo. 
   *  (Z tym ograniczeniem, że pierwsza cyfra liczby
   *  musi być różna od zera).
   */
  
  public static BigInteger random(int numDigits) {
    StringBuffer s = new StringBuffer("");
    for(int i=0; i<numDigits; i++) {
      if (i == 0) {
        // Pierwsza cyfra musi być różna od zera.
        s.append(randomDigit(false)); 
      } else {
        s.append(randomDigit(true));
      }
    }
    return(new BigInteger(s.toString()));
  }

  /** Prosty program uruchamiany z poziomu wiersza poleceń,
   *  umożliwiający przeprowadzanie testów. Należy podać liczbę
   *  cyfr, a program wybierze losową liczbę pierwszą
   *  o podanej długości oraz 50 liczb pierwszych większych od niej.
   */
  
  public static void main(String[] args) {
    int numDigits;
    try {
      numDigits = Integer.parseInt(args[0]);
    } catch (Exception e) { // Brak lub błędne parametry
      numDigits = 150;
    }
    BigInteger start = random(numDigits);
    for(int i=0; i<50; i++) {
      start = nextPrime(start);
      System.out.println("Prime " + i + " = " + start);
    }
  }
}
