package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

/** Tworzy listę wszystkich nagłówków żądania 
 *  przesłanych w tym żądaniu.
 */

public class ShowRequestHeaders extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html; charset=ISO-8859-2");
    PrintWriter out = response.getWriter();
    String title = "Prezentacja nagłówków żądania";
    out.println(ServletUtilities.headWithTitle(title) +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H1 ALIGN=CENTER>" + title + "</H1>\n" +
                "<B>Metoda: </B>" +
                request.getMethod() + "<BR>\n" +
                "<B>Żądane URI: </B>" +
                request.getRequestURI() + "<BR>\n" +
                "<B>Protokół: </B>" +
                request.getProtocol() + "<BR><BR>\n" +
                "<TABLE BORDER=1 ALIGN=CENTER>\n" +
                "<TR BGCOLOR=\"#FFAD00\">\n" +
                "<TH>Nazwa nagłówka</TH><TH>Wartość nagłówka</TH></TR>");
    Enumeration headerNames = request.getHeaderNames();
    while(headerNames.hasMoreElements()) {
      String headerName = (String)headerNames.nextElement();
      out.println("<TR><TD>" + headerName + "</TD>");
      out.println("    <TD>" + request.getHeader(headerName) + "</TD></TR>");
    }
    out.println("</TABLE>\n</BODY></HTML>");
  }

  /** Niech ten sam serwlet obsługuje zarówno żądania 
   *  GET jak i POST
   */
  
  public void doPost(HttpServletRequest request,
                     HttpServletResponse response)
      throws ServletException, IOException {
    doGet(request, response);
  }
}
