package coreservlets;

import java.io.*;
import javax.servlet.http.*;
import java.util.zip.*;

/** Trzy statyczne metody pomocnicze ułatwiające stosowanie 
 *  kompresji przesyłanych stron WWW.
 *  <UL>
 *    <LI>isGzipSupported: czy przeglądarka obsługuje kompresję?
 *    <LI>isGzipDisabled: czy użytkownik przesłał flagę
 *        informującą, że należy wyłączyć kompresję tej odpowiedzi?
 *        (Przydatne podczas porównywania czasów przesyłania stron
 *        skompresowanych i w normalnej postaci, w tej samej 
 *        przeglądarce.)
 *    <LI>getGzipWriter: zwraca obiekt PrintWriter używający 
 *        kompresującego strumienia wyjściowego.
 *  </UL>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class GzipUtilities {
  
  /** Czy klient obsługuje kompresję gzip? */
  
  public static boolean isGzipSupported
      (HttpServletRequest request) {
    String encodings = request.getHeader("Accept-Encoding");
    return((encodings != null) &&
           (encodings.indexOf("gzip") != -1));
  }

  /** Czy użytkownik wyłączył kompresję gzip (na przykład w celach testowych)? */
  
  public static boolean isGzipDisabled
      (HttpServletRequest request) {
    String flag = request.getParameter("disableGzip");
    return((flag != null) && (!flag.equalsIgnoreCase("false")));
  }

  /** Zwraca kompresujący obiekt PrintWriter. */
  
  public static PrintWriter getGzipWriter
      (HttpServletResponse response) throws IOException {
    return(new PrintWriter
            (new GZIPOutputStream
              (response.getOutputStream())));
  }
}
