package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Serwlet generujący komunikaty w zależności od używanej
 *  przeglądarki. Ilustruje on zastosowanie nagłówka 
 *  żądania User-Agent do rozróżniania przeglądarek.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class BrowserInsult extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html; charset=ISO-8859-2");
    PrintWriter out = response.getWriter();
    String title, message;
    // Dla uproszczenia zakładamy, że jedynymi używanymi 
    // przeglądarkami są Netscape oraz Internet Explorer.
    String userAgent = request.getHeader("User-Agent");
    if ((userAgent != null) &&
        (userAgent.indexOf("MSIE") != -1)) {
      title = "Pachołek Microsoftu";
      message = "Witaj, o pozbawiony charakteru sługusie " +
                "potężnego imperium.";
    } else {
      title = "Z góry przegrany rebeliant Netscape'a";
      message = "Raduj się póki możesz. " +
                "I tak kiedyś <I>zostaniesz</I> zasymilowany!";
    }
    String docType =
      "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
      "Transitional//EN\">\n";
    out.println(docType +
                "<HTML>\n" +
                "<HEAD><TITLE>" + title + "</TITLE></HEAD>\n" +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H1 ALIGN=CENTER>" + title + "</H1>\n" +
                message + "\n" +
                "</BODY></HTML>");
  }
}
