package coreservlets;

import javax.servlet.http.*;

public class ServletUtilities {
  public static final String DOCTYPE =
    "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
    "Transitional//EN\">";

  public static String headWithTitle(String title) {
    return(DOCTYPE + "\n" +
           "<HTML>\n" +
           "<HEAD><TITLE>" + title + "</TITLE></HEAD>\n");
  }



  /** Metoda odczytuje parametr o podanej nazwie, konwertuje
   *  go do liczby całkowitej i zwraca. Jeśli parametr nie 
   *  istnieje lub jeśli został zapisany w niewłaściwej postaci
   *  to metoda zwraca podaną wartość domyślną.
   */
  
  public static int getIntParameter(HttpServletRequest request,
                                    String paramName,
                                    int defaultValue) {
    String paramString = request.getParameter(paramName);
    int paramValue;
    try {
      paramValue = Integer.parseInt(paramString);
    } catch(NumberFormatException nfe) { // null or bad format
      paramValue = defaultValue;
    }
    return(paramValue);
  }

  public static double getDoubleParameter
                                 (HttpServletRequest request,
                                  String paramName,
                                  double defaultValue) {
    String paramString = request.getParameter(paramName);
    double paramValue;
    try {
      paramValue = Double.parseDouble(paramString);
    } catch(NumberFormatException nfe) { // null or bad format
      paramValue = defaultValue;
    }
    return(paramValue);
  }
  /** Zastępuje znaki specjalne języka HTML odpowiednimi
   *  symbolami HTML.
   */
  
  // Należy zauważyć, że bardziej szczegółowe informacje
  // na temat tej metody nie zostały zapisane przy użyciu
  // standardowego foramtu służącego do generacji dokumentacji
  // w języku Java. Jest to związane z problemami jakich
  // przysparza wyświetlanie znaków specjalnych języka HTML
  // zarównow w zwyczajnym tekście jak i na stronie WWW.
  //
  // Ta metoda, w przekazanym łańcuchu znaków zamienia wszystkie
  // wystąpienia znaku '<' kombinacją znaków '&lt;' oraz wszystkie
  // wystąpienia znaku '>' kombinacją znaków '&gt;' oraz (aby 
  // poprawnie obsługiwać przypadku wystąpienia tych znaków w wartościach
  // atrybutów) wszystkie wystąpienia cudzysłowów na kombinacje znaków
  // '&quote', wszystkie wystąpienia '&' na '&amp;'. 
  // Bez zastosowania filtrowania tego typu żaden dowolny łańcuch
  // znaków nie może być wstawiony do kodu strony WWW.

  public static String filter(String input) {
    if (!hasSpecialChars(input)) {
      return(input);
    }
    StringBuffer filtered = new StringBuffer(input.length());
    char c;
    for(int i=0; i<input.length(); i++) {
      c = input.charAt(i);
      switch(c) {
        case '<': filtered.append("&lt;"); break;
        case '>': filtered.append("&gt;"); break;
        case '"': filtered.append("&quot;"); break;
        case '&': filtered.append("&amp;"); break;
        default: filtered.append(c);
      }
    }
    return(filtered.toString());
  }

  private static boolean hasSpecialChars(String input) {
    if ((input != null) && (input.length() > 0)) {
      char c;
      for(int i=0; i<input.length(); i++) {
        c = input.charAt(i);
        switch(c) {
          case '<': return true;
          case '>': return true;
          case '"': return true;
          case '&': return true;
        }
      }
    }
    return false;
  }

}
