package coreservlets.beans;

import coreservlets.*;

/** Komponent reprezentujący informacje o ofercie rejestrowanej
 *  na witrynie aukcyjnej. Używany w celu przedstawienia 
 *  możliwości ponownego wyświetlania formularza, w przypadku
 *  gdy nie zostaną w nim podane wszystkie niezbędne dane.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class BidInfo {
  private String itemID = "";
  private String itemName = "";
  private String bidderName = "";
  private String emailAddress = "";
  private double bidPrice = 0;
  private boolean autoIncrement = false;

  public String getItemName() {
    return(itemName);
  }

  public void setItemName(String itemName) {
    this.itemName = ServletUtilities.filter(itemName);
  }

  public String getItemID() {
    return(itemID);
  }

  public void setItemID(String itemID) {
    this.itemID = ServletUtilities.filter(itemID);
  }
  
  public String getBidderName() {
    return(bidderName);
  }

  public void setBidderName(String bidderName) {
    this.bidderName = ServletUtilities.filter(bidderName);
  }

  public String getEmailAddress() {
    return(emailAddress);
  }

  public void setEmailAddress(String emailAddress) {
    this.emailAddress = ServletUtilities.filter(emailAddress);
  }

  public double getBidPrice() {
    return(bidPrice);
  }

  public void setBidPrice(double bidPrice) {
    this.bidPrice = bidPrice;
  }

  public boolean isAutoIncrement() {
    return(autoIncrement);
  }

  public void setAutoIncrement(boolean autoIncrement) {
    this.autoIncrement = autoIncrement;
  }

  /** Czy zostały podane wszystkie wymagane dane? Wartości
   *  wszystkich pól za wyjątkiem autoIncrement muszą być
   *  podane jawnie. Pole autoIncrement przyjmuje domyślną
   *  wartość false.
   */

  public boolean isComplete() {
    return(hasValue(getItemID()) &&
           hasValue(getItemName()) &&
           hasValue(getBidderName()) &&
           hasValue(getEmailAddress()) &&
           (getBidPrice() > 0));
  }

  /** Czy jakieś dane zostały podane? */

  public boolean isPartlyComplete() {
    boolean flag =
           (hasValue(getItemID()) ||
           hasValue(getItemName()) ||
           hasValue(getBidderName()) ||
           hasValue(getEmailAddress()) ||
           (getBidPrice() > 0) ||
           isAutoIncrement());
    return(flag);
  }

  private boolean hasValue(String val) {
    return((val != null) && (!val.equals("")));
  }
}