package coreservlets.beans;

import java.util.*;
import javax.servlet.http.*;
import org.apache.commons.beanutils.BeanUtils;

/** Narzędzia do zapisywania danych w komponentach, zazwyczaj
 *  na podstawie informacji zawartych w parametrach żądania.
 *  Klasa wymaga zainstalowania trzech pakietów biblioteki
 *  Apache Commons: beanutils, collections oraz logging.
 *  Pakiety te można pobrać ze strony 
 *  http://jakarta.apache.org/commons/. Połączenie do tej 
 *  strony zostało także umieszczone na witrynie zawierającej
 *  archiwum kodu źródłowego przykładów używanych w niniejszej
 *  książce (http://www.coreservlets.com/).
 *  <P>
 *  Należy zauważyć, że ta klasa należy do pakietu 
 *  coreservlets.beans, a zatem należy ją umieścić w katalogu
 *  .../coreservlets/beans/.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class BeanUtilities {
  /** Metoda sprawdza wszystkie parametry żądania i określa
   *  czy odpowiadają one włściwościom obiektu (czyli 
   *  metodom setXxx). Jeśli tak, to wartość parametru 
   *  żądania jest przekazywana do metody. Jeśli metoda
   *  oczekuje przekazania wartości typu int, Integer,
   *  double, Double, lub dowolnego innego typu podstawowego
   *  lub klasy opakowującej, to niezbędne operacje 
   *  związane z analizą wartości parametru oraz jej 
   *  konwersją są wyknywane automatycznie. Jeśli wartość
   *  parametru żądania została zapisana w nieprawidłowy 
   *  sposób (nie można jej skonwertować do odpowiedniego 
   *  typu), to w przypadku wartości liczbowych jest im 
   *  przypisywana wartość zero, natomiast wartościom 
   *  logicznym wartość false - nie są zgłaszane żadne 
   *  wyjątki.
   */
  
  public static void populateBean(Object formBean,
                                  HttpServletRequest request) {
    populateBean(formBean, request.getParameterMap());
  }

  /** Zapisuje wartości w komponencie na podstawie obiektu 
   *  typu Map: klucze tego obiektu odpowiadają właściwościom
   *  komponentu, a wartości tych kluczy zostaną przypisane
   *  odpowiednim właściwościom. Konwersja danych jest 
   *  wykonywana automatycznie, zgodnie z informacjami podanymi 
   *  w opisie poprzedniej metody.
   */
  
  public static void populateBean(Object bean,
                                  Map propertyMap) {
    try {
      BeanUtils.populate(bean, propertyMap);
    } catch(Exception e) {
      // Pusta klauzula catch. Moga do niej trafiać
      // wyjątki dwóch typów:
      // java.lang.IllegalAccessException oraz
      // java.lang.reflect.InvocationTargetException.
      // W obu przypadkach należy je zignorować i nie 
      // wykonywać żadnych operacji.
    }
  }
}
