import java.net.*;  
import java.io.*;

/** Punkt startowy dla klientów sieciowych. W konkretnych implementacjach
 *  Konieczne jest nadpisanie handleConnection, ale w wielu przypadkach
 *  connect może zostać niezmieniona. Wykorzystuje SocketUtil aby uprościć
 *  tworzenie PrintWriter i BufferedReader.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class NetworkClient {
  protected String host;
  protected int port;

  /** Zapamiętuje host i port. Połączenie nie zostanie nawiązane do
   *  momentu wywołania metody connect.
   */
  
  public NetworkClient(String host, int port) {
    this.host = host;
    this.port = port;
  }

  /** Nawiązuje połącznie i przekazuje socket do metody handleConnection.
   */
  
  public void connect() {
    try {
      Socket client = new Socket(host, port);
      handleConnection(client);
    } catch(UnknownHostException uhe) {
      System.out.println("Nieznany host: " + host);
      uhe.printStackTrace();
    } catch(IOException ioe) {
      System.out.println("IOException: " + ioe);
      ioe.printStackTrace();
    }
  }

  /** Tą metodę należy nadpisać tworząc klienta sieciowego
   *  dopasowanego do konkretnego zadania. Domyślna implementacja
   *  wysyła pojedynczy wiersz zawierający tekst "Generic Network
   *  Client", odczytuje jednen wiersz odpowiedzi, wypisuje go
   *  i kończy pracę.
   */
  
  protected void handleConnection(Socket client)
      throws IOException {
    PrintWriter out =
      SocketUtil.getWriter(client);
    BufferedReader in =
      SocketUtil.getReader(client);
    out.println("Generic Network Client");
    System.out.println
      ("Generic Network Client:\n" +
       "Połączono z " + host +
       " i otrzymano '" + in.readLine() + "' w odpowiedzi");
    client.close();
  }

  /** Nazwa hosta z którym się komunikujemy. */
  
  public String getHost() {
    return(host);
  }

  /** Port z którym nawiązujemy połaczenie. */
  
  public int getPort() {
    return(port);
  }
}
