import java.awt.*;
import java.net.*;
import java.io.*;

/** Klient sieciowy wykorzystany przez klasy WebClient.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class HttpClient extends NetworkClient {
  private String requestLine;
  private String[] requestHeaders;
  private TextArea outputArea;
  private Interruptible app;
  
  public HttpClient(String host, int port,
                    String requestLine, String[] requestHeaders,
                    TextArea outputArea, Interruptible app) {
    super(host, port);
    this.requestLine = requestLine;
    this.requestHeaders = requestHeaders;
    this.outputArea = outputArea;
    this.app = app;
    if (checkHost(host))
      connect();
  }

  protected void handleConnection(Socket uriSocket)
      throws IOException {
    try {
      PrintWriter out = SocketUtil.getWriter(uriSocket);
      BufferedReader in = SocketUtil.getReader(uriSocket);
      outputArea.setText("");
      out.println(requestLine);
      for(int i=0; i<requestHeaders.length; i++) {
        if (requestHeaders[i] == null)
          break;
        else
          out.println(requestHeaders[i]);
      }
      out.println();
      String line;
      while ((line = in.readLine()) != null &&
             !app.isInterrupted())
        outputArea.append(line + "\n");
      if (app.isInterrupted())
        outputArea.append("---- Pobieranie danych przerwane ----");
    } catch(Exception e) {
      outputArea.setText("Wyjątek: " + e);
    }
  }

  private boolean checkHost(String host) {
    try {
      InetAddress.getByName(host);
      return(true);
    } catch(UnknownHostException uhe) {
      outputArea.setText("Nieznany host: " + host);
      return(false);
    }
  }
}
