package coreservlets.beans;

import java.sql.*;

/** Obiekty tej klasy przechowują informacje niezbędne
 *  do utworzenia połączenia JDBC z bazą danych.
 *  Przechowywane są następujące informacje
 *  <UL>
 *    <LI>nazwa połączenia
 *    <LI>opis połączenia
 *    <LI>nazwa klasy sterownika
 *    <LI>adres URL do nawiązania połączenia
 *    <LI>nazwa użytkownika
 *    <LI>hasło
 *  </UL>
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall & Larry Brown; można kopiować i modyfikować bez ograniczeń.
 */

public class ConnectionInfoBean {
  private String connectionName;
  private String description;
  private String driver;
  private String url;
  private String username;
  private String password;

  public ConnectionInfoBean() { }

  public ConnectionInfoBean(String connectionName,
                            String description,
                            String driver,
                            String url,
                            String username,
                            String password) {
    setConnectionName(connectionName);
    setDescription(description);
    setDriver(driver);
    setURL(url);
    setUsername(username);
    setPassword(password);
  }

  public void setConnectionName(String connectionName) {
    this.connectionName = connectionName;
  }

  public String getConnectionName() {
    return(connectionName);
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getDescription() {
    return(description);
  }

  public void setDriver(String driver) {
    this.driver = driver;
  }

  public String getDriver() {
    return(driver);
  }

  public void setURL(String url) {
    this.url = url;
  }

  public String getURL() {
    return(url);
  }

  public void setUsername(String username) {
    this.username = username;
  }

  public String getUsername() {
    return(username);
  }

  public void setPassword(String password) {
    this.password = password;
  }

  public String getPassword() {
    return(password);
  }

  public Connection getConnection() {
    return(getConnection(driver, url, username, password));

  }

  /** Utworzenie połączenia JDBC; w razie problemów
   *  zwracana jest wartość null.
   */

  public static Connection getConnection(String driver,
                                         String url,
                                         String username,
                                         String password) {
    try {
      Class.forName(driver);
      Connection connection =
        DriverManager.getConnection(url, username,
                                    password);
      return(connection);
    } catch(ClassNotFoundException cnfe) {
      System.err.println("Błąd podczas ładowania sterownika: " + cnfe);
      return(null);
    } catch(SQLException sqle) {
      System.err.println("Błąd podczas nawiązywania połączenia: " + sqle);
      return(null);
    }
  }
}    