package coreservlets;

import java.sql.*;
import coreservlets.beans.*;

/** Przykład demonstrujący wykonywanie bloku poleceń SQL
 *  jako jednej transakcji. Konkretnie, klasa dodaje 
 *  do tabeli music cztery nowe rekordy. Operacje te 
 *  są wykonywane jako jeden blok transakcji, zatem 
 *  w razie wystąpienia jakiś problemów są one wycofywane
 *  i w bazie danych nie zostają zapisane żadne zmiany .
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall & Larry Brown; można kopiować i modyfikować bez ograniczeń.
 */

public class Transactions {
  public static void main(String[] args) {
    if (args.length < 5) {
      printUsage();
      return;
    }
    String vendor = args[4];
    // Aby wczytać informacje o sterowniku z pliku XML
    // i nie używać informacji podanych na stałe w klasie
    // DriverUtilities, należy wywołać metodę 
    // DriverUtilities2.loadDrivers().
    
    DriverUtilities.loadDrivers();
    if (!DriverUtilities.isValidVendor(vendor)) {
      printUsage();
      return;
    }
    String driver = DriverUtilities.getDriver(vendor);
    String host = args[0];
    String dbName = args[1];
    String url =
      DriverUtilities.makeURL(host, dbName, vendor);
    String username = args[2];
    String password = args[3];
    doTransactions(driver, url, username, password);
  }

  private static void doTransactions(String driver,
                                     String url,
                                     String username,
                                     String password) {
    String[] transaction =
    { "INSERT INTO music VALUES " +
      " ( 9, 'Chopin',       'No. 2 in F minor',  100, 17.99)",
      "INSERT INTO music VALUES " +
      " (10, 'Tchaikovsky',   'No. 1 in Bb minor', 100, 24.99)",
      "INSERT INTO music VALUES " +
      " (11, 'Ravel',        'No. 2 in D major',  100, 14.99)",
      "INSERT INTO music VALUES " +
      " (12, 'Schumann',     'No. 1 in A minor',  100, 14.99)"};
    TransactionBean bean = new TransactionBean();
    try {
      bean.setConnection(driver, url, username, password);
      bean.execute(transaction);
    } catch (SQLException sqle) {
      System.err.println("Błąd transakcji: " + sqle);
    } finally {
      bean.close();
    }
  }

  private static void printUsage() {
    System.out.println("Sposób użycia: Transactions komputer " +
                       "nazwaBazy nazwaUżytkownika hasło " +
                       "typ.");
  }
}                                     