package coreservlets;

/** Serwlet tworzy zmienne dostępne w określonym zakresie 
 *  (czyli obiekty zapisywane jako atrybuty w pewnych 
 *	standardowych miejscach). Następnie przekazuje obsługę
 *  żądania do strony JSP, która wyświetla wartości zapisane
 *	przez serwlet przy użyciu języka wyrażeń.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class ScopedVars extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    request.setAttribute("attribute1", "Pierwsza wartość");
    HttpSession session = request.getSession();
    session.setAttribute("attribute2", "Druga wartość");
    ServletContext application = getServletContext();
    application.setAttribute("attribute3",
                             new java.util.Date());
    request.setAttribute("repeated", "żądanie");
    session.setAttribute("repeated", "Sesja");
    application.setAttribute("repeated", "Obiekt ServletContext");
    RequestDispatcher dispatcher =
      request.getRequestDispatcher("/el/scoped-vars.jsp");
    dispatcher.forward(request, response);
  }
}
