package coreservlets;  

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Odczytuje parametry żądania firstName i lastName i przekazuje
 *  obsługę żądania do strony JSP w celu wyświetlenia danych. 
 *	W celu zapamiętania wcześniej podanych informacji są one 
 *  zapisywane w obiekcie sesji.
 */

public class RegistrationServlet extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    HttpSession session = request.getSession();
    NameBean nameBean =
      (NameBean)session.getAttribute("nameBean");
    if (nameBean == null) {
      nameBean = new NameBean();
      session.setAttribute("nameBean", nameBean);
    }
    String firstName = request.getParameter("firstName");
    if ((firstName != null) && (!firstName.trim().equals(""))) {
      nameBean.setFirstName(firstName);
    }
    String lastName = request.getParameter("lastName");
    if ((lastName != null) && (!lastName.trim().equals(""))) {
      nameBean.setLastName(lastName);
    }
    String address = "/WEB-INF/mvc-wspoluzk/ShowName.jsp";
    RequestDispatcher dispatcher =
      request.getRequestDispatcher(address);
    dispatcher.forward(request, response);
  }
}
