package coreservlets;

import java.util.*;
import java.math.BigInteger;

/** Tworzy listę (klasa ArrayList) dużych liczb pierwszych
 *  wykorzystując do obliczeń wątek o niskim priorytecie 
 *  działający w tle. Klasa udostępnia kilka prostych 
 *  metod dostępu umożliwiających pracę wielowątkową.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class PrimeList implements Runnable {
  private ArrayList primesFound;
  private int numPrimes, numDigits;

  /** Metoda odnajduje podaną ilość (numPrimes) liczb pierwszych, 
   *  z których każda ma długość co najmniej numDigits cyfr. 
   *  Metodę można wywołać w taki sposób, aby wyniki zostały 
   *  zwrócone dopiero po całkowitym zakończeniu obliczeń, lub 
   *  aby zakończyła się bezzwłocznie - w takim przypadku
   *  istnieje możliwość sprawdzania, na jakim etapie 
   *  są w danej chwili obliczenia.
   */
  
  public PrimeList(int numPrimes, int numDigits,
                   boolean runInBackground) {
    primesFound = new ArrayList(numPrimes);
    this.numPrimes = numPrimes;
    this.numDigits = numDigits;
    if (runInBackground) {
      Thread t = new Thread(this);
      // Zastosowano wątek o niskim priorytecie, aby nadmiernie
      // nie obciążać serwera.
      t.setPriority(Thread.MIN_PRIORITY);
      t.start();
    } else {
      run();
    }
  }

  public void run() {
    BigInteger start = Primes.random(numDigits);
    for(int i=0; i<numPrimes; i++) {
      start = Primes.nextPrime(start);
      synchronized(this) {
        primesFound.add(start);
      }
    }
  }

  public synchronized boolean isDone() {
    return(primesFound.size() == numPrimes);
  }

  public synchronized ArrayList getPrimes() {
    if (isDone())
      return(primesFound);
    else
      return((ArrayList)primesFound.clone());
  }

  public int numDigits() {
    return(numDigits);
  }
  
  public int numPrimes() {
    return(numPrimes);
  }
  
  public synchronized int numCalculatedPrimes() {
    return(primesFound.size());
  }
}
