package coreservlets;

/** Klasa pomocnicza definiująca metody statyczne służące
 *  do generacji adresów URL do najpopularniejszych 
 *  wyszukiwarek.
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall; można kopiować i modyfikować bez ograniczeń.
 */

public class SearchUtilities {
  private static SearchSpec[] commonSpecs =
    { new SearchSpec("Google",
                     "http://www.google.com/search?q="),
      new SearchSpec("AllTheWeb",
                     "http://www.alltheweb.com/search?q="),
      new SearchSpec("Yahoo",
                     "http://search.yahoo.com/bin/search?p="),
      new SearchSpec("AltaVista",
                     "http://www.altavista.com/web/results?q="),
      new SearchSpec("Lycos",
                     "http://search.lycos.com/default.asp?query="),
      new SearchSpec("HotBot",
                     "http://www.hotbot.com/default.asp?query="),
      new SearchSpec("MSN",
                     "http://search.msn.com/results.asp?q="),
    };
  
  public static SearchSpec[] getCommonSpecs() {
    return(commonSpecs);
  }

  /** Na podstawie nazwy wyszukiwarki oraz łańcucha zapytania
   *  ta metoda generuje adres URL strony wynikowej dla
   *  podanej wyszukiwarki. Jeśli nazwa wyszukiwarki nie jest
   *  znana, metoda zwraca wartość null.
   */
  
  public static String makeURL(String searchEngineName,
                               String searchString) {
    SearchSpec[] searchSpecs = getCommonSpecs();
    String searchURL = null;
    for(int i=0; i<searchSpecs.length; i++) {
      SearchSpec spec = searchSpecs[i];
      if (spec.getName().equalsIgnoreCase(searchEngineName)) {
        searchURL = spec.makeURL(searchString);
        break;
      }
    }
    return(searchURL);
  }
}
