import java.net.*;
import java.io.*;

/** Wielowątkowa wersja EchoServera. 
 *  <P>
 *  Przykłady z książki Java Servlet i JavaServer Pages. Wydanie II.
 *  Wydawnictwo HELION
 *  http://helion.pl/.
 *  &copy; 2003 Marty Hall & Larry Brown; można kopiować i modyfikować bez ograniczeń.
 */

public class ThreadedEchoServer extends EchoServer
                                implements Runnable {
  public static void main(String[] args) {
    int port = 8088;
    if (args.length > 0) {
      try {
        port = Integer.parseInt(args[0]);
      } catch(NumberFormatException nfe) {}
    }
    ThreadedEchoServer echoServer =
      new ThreadedEchoServer(port, 0);
    echoServer.serverName = "Threaded EchoServer";
  }

  public ThreadedEchoServer(int port, int connections) {
    super(port, connections);
  }

  /** Nowa wersja metody handleConnection uruchamia wątek. Wątek
   *  ten wykorzystuje <I>starą</I> wersję handleConnection,
   *  dzięki czemu serwer działa tak samo w wersji wielowątkowej.
   *  Wątek przechowuje referencję do Socketu ponieważ metoda run
   *  nie ma argumentów, a zapamiętanie tej referencji w polu klasy
   *  serwera niesie ze sobą ryzyko nadpisania jej jeżeli kolejny
   *  wątek rozpocznie się zanim metoda run skopiuje referencję.
   */
                                  
  public void handleConnection(Socket server) {
    Connection connectionThread = new Connection(this, server);
    connectionThread.start();
  }
    
  public void run() {
    Connection currentThread =
      (Connection)Thread.currentThread();
    try {
      super.handleConnection(currentThread.getSocket());
    } catch(IOException ioe) {
      System.out.println("IOException: " + ioe);
      ioe.printStackTrace();
    }
  }
}

/** Najzwyklejszy wątek uzupełniony o pole przechowujące
 *  obiekt klasy Socket. Dzięki temu w bezpieczny sposób
 *  przekazujemy go z handleConnection do metody run.
 */

class Connection extends Thread {
  private Socket serverSocket;

  public Connection(Runnable serverObject,
                    Socket serverSocket) {
    super(serverObject);
    this.serverSocket = serverSocket;
  }
  
  public Socket getSocket() {
    return serverSocket;
  }
}
