package isrp.model.service.impl;

import java.util.List;

import isrp.hibernate.model.businessobject.Paper;
import isrp.hibernate.model.businessobject.Review;
import isrp.hibernate.model.businessobject.User;
import isrp.hibernate.model.dao.PaperDao;
import isrp.hibernate.model.dao.ReviewDao;
import isrp.hibernate.model.dao.UserDao;
import isrp.hibernate.model.dao.factory.DaoFactory;
import isrp.hibernate.model.util.email.EmailConfiguration;
import isrp.hibernate.model.util.email.EmailMessagesUtil;
import isrp.hibernate.model.util.email.EmailSender;
import isrp.model.service.UserService;

public class UserServiceImpl implements UserService {

	public UserServiceImpl() {
	}

	@Override
	public String getAdministratorEmail() {
		UserDao uDao = DaoFactory.getInstance().getUserDao();
		return uDao.getAdministratorEmail();
	}

	@Override
	public User findById(int id) {
		UserDao uDao = DaoFactory.getInstance().getUserDao();
		return (User) uDao.findById(id);
	}

	@Override
	public void update(User user) {
		UserDao uDao = DaoFactory.getInstance().getUserDao();
		uDao.saveOrUpdate(user);

	}

	@Override
	public User checkIfEmailExistInDB(String email) {
		UserDao uDao = DaoFactory.getInstance().getUserDao();
		return uDao.checkIfEmailExistInDB(email);
	}

	@Override
	public void registerNewAuthor(User user,
			EmailConfiguration emailConfiguration) {
		UserDao uDao = DaoFactory.getInstance().getUserDao();
		uDao.save(user);
		EmailSender eSender = new EmailSender(emailConfiguration);
		eSender.sendEMail(EmailMessagesUtil.newAuthorRegistrationMessage(user));
	}

	@Override
	public void registerNewReviewer(User user, String passwordCopy,
			EmailConfiguration emailConfiguration) {
		UserDao uDao = DaoFactory.getInstance().getUserDao();
		uDao.save(user);
		EmailSender eSender = new EmailSender(emailConfiguration);
		eSender.sendEMail(EmailMessagesUtil.newReviewerRegistrationMessage(
				user, passwordCopy));

	}

	@Override
	public User authenticate(String email, String password) {
		UserDao uDao = DaoFactory.getInstance().getUserDao();
		return uDao.authenticate(email, password);
	}

	@Override
	public boolean delete(User user) {
		UserDao uDao = DaoFactory.getInstance().getUserDao();
		// zabezpieczenie przed usuniciem uytkownika jeli posiada jakie
		// prace w systemie.
		PaperDao pDao = DaoFactory.getInstance().getPaperDao();
		List<Paper> papers = pDao.getUserPapers(user.getId(), null);
		if (papers.size() > 0) {
			return false;
		}
		// zabezpieczenie przed usuniciem uytkownika jeli posiada recenzje w
		// systemie.
		ReviewDao rDao = DaoFactory.getInstance().getReviewDao();
		List<Review> reviews = rDao.getReviewerReviews(user.getId());
		if (reviews.size() > 0) {
			return false;
		}
		uDao.delete(user);
		return true;
	}

	@Override
	public void saveNewPassword(User user, String password,
			EmailConfiguration emailConfiguration) {
		UserDao uDao = DaoFactory.getInstance().getUserDao();
		uDao.saveOrUpdate(user);
		EmailSender eSender = new EmailSender(emailConfiguration);
		eSender.sendEMail(EmailMessagesUtil.sendNewPasswordToUser(user,
				password));
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<User> getReviewers() {
		UserDao uDao = DaoFactory.getInstance().getUserDao();
		return uDao.getReviewers();
	}

	@Override
	public List<User> getAllUsers(String sortColumn) {
		UserDao uDao = DaoFactory.getInstance().getUserDao();
		return uDao.getUsers(sortColumn);
	}

}
