package isrp.utils;


import isrp.hibernate.model.util.Md5HashCode;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import javax.el.ELResolver;
import javax.faces.context.FacesContext;

public class IsrpUtils {
	
	public static String generateNewPassword(String input){
		String pass=Md5HashCode.getMd5HashCode(input);
        Random rand = new Random();
        int start=Math.abs(rand.nextInt())%25;
        pass = pass.substring(start,start+7);
		return pass;				
	}
	
	public static Date getCurrentDate(){
		return Calendar.getInstance().getTime();
	}
	
	public static void setBean(FacesContext faces,String scopeName,String beanName,Object bean){
		ELResolver elResolver = faces.getApplication().getELResolver();		
		Object scope = elResolver.getValue(faces.getELContext(), null, scopeName);
		faces.getApplication().getELResolver().setValue(faces.getELContext(),scope , beanName, bean);
	}
	
	public static Object getBean(FacesContext faces,String scopeName,String beanName){
		ELResolver elResolver = faces.getApplication().getELResolver();		
		Object scope = elResolver.getValue(faces.getELContext(), null, scopeName);
		return faces.getApplication().getELResolver().getValue(faces.getELContext(), scope, beanName);
	}

}
