<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:f="http://java.sun.com/jsf/core"
	xmlns:h="http://java.sun.com/jsf/html" version="2.0">
	<jsp:directive.page language="java"
		contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" />
	<jsp:text>
		<![CDATA[ <?xml version="1.0" encoding="UTF-8" ?> ]]>
	</jsp:text>
	<jsp:text>
		<![CDATA[ <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"> ]]>
	</jsp:text>
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
	<jsp:include page='includes/header.jsp'>
		<jsp:param name="title" value="register page" />
	</jsp:include>
	</head>
	<body>
	<f:view>
		<jsp:include page='includes/header_body.jsp' />
		<jsp:include page='includes/topMenu.jsp' />
		<jsp:include page='includes/leftMenu.jsp' />	
		<div id="CONTENT" class="content"><div class="register">
		<h:messages globalOnly="true"></h:messages>	
		<h:form>		
			<h:panelGrid border="0" columns="3">
				<f:facet name="header">					
					<h:outputText value="#{empty visitBean.currentUser.id ? resources['addEditUser.form.label.registration'] : resources['addEditUser.form.label.edit']}"></h:outputText>
				</f:facet>
								
				<h:outputLabel value="#{resources['addEditUser.field.label.role']}" for="role" rendered="#{visitBean.user.role==1 and (empty visitBean.currentUser.id)}"/>
				<h:selectOneListbox id="role" value="#{visitBean.currentUser.role}" required="true" size="1" rendered="#{visitBean.user.role==1 and (empty visitBean.currentUser.id)}">
					<f:selectItem itemValue="1" itemLabel="#{resources['user.role.admin']}"/>
					<f:selectItem itemValue="2" itemLabel="#{resources['user.role.author']}"/>
					<f:selectItem itemValue="3" itemLabel="#{resources['user.role.reviewer']}"/>
				</h:selectOneListbox>
				<h:panelGroup rendered="#{visitBean.user.role==1 and (empty visitBean.currentUser.id)}">				
				</h:panelGroup>
				
				
				<h:outputLabel value="#{resources['addEditUser.field.label.title']}" for="title"/>
				<h:inputText id="title" required="true" value="#{visitBean.currentUser.title}">
					<f:validateLength maximum="50"/>
				</h:inputText>
				<h:message for="title"></h:message>
								
				<h:outputLabel value="#{resources['addEditUser.field.label.firstName']}" for="firstName"/>
				<h:inputText id="firstName" required="true" value="#{visitBean.currentUser.firstName}">
					<f:validateLength maximum="100"/>
				</h:inputText>
				<h:message for="firstName"></h:message>
				
				<h:outputLabel value="#{resources['addEditUser.field.label.lastName']}" for="lastName"/>
				<h:inputText id="lastName" required="true" value="#{visitBean.currentUser.lastName}">
					<f:validateLength maximum="100"/>
				</h:inputText>
				<h:message for="lastName"></h:message>
				
				<h:outputLabel value="#{resources['addEditUser.field.label.organization']}" for="organization"/>
				<h:inputText id="organization" required="true" value="#{visitBean.currentUser.organization}">
					<f:validateLength maximum="100"/>
				</h:inputText>
				<h:message for="organization"></h:message>
				
				<h:outputLabel value="#{resources['addEditUser.field.label.department']}" for="department"/>
				<h:inputText id="department" required="true" value="#{visitBean.currentUser.department}">
					<f:validateLength  maximum="100"/>
				</h:inputText>
				<h:message for="department"></h:message>
				
				<h:outputLabel value="#{resources['addEditUser.field.label.street']}" for="street"/>
				<h:inputText id="street" required="true" value="#{visitBean.currentUser.street}">
					<f:validateLength maximum="100"/>
				</h:inputText>
				<h:message for="street"></h:message>
				
				<h:outputLabel value="#{resources['addEditUser.field.label.zipCode']}" for="zipCode"/>
				<h:inputText id="zipCode" required="true" value="#{visitBean.currentUser.zipCode}">
					<f:validateLength  maximum="6"/>
				</h:inputText>
				<h:message for="zipCode"></h:message>
				
				<h:outputLabel value="#{resources['addEditUser.field.label.city']}" for="city"/>
				<h:inputText id="city" required="true" value="#{visitBean.currentUser.city}">
					<f:validateLength  maximum="100"/>
				</h:inputText>
				<h:message for="city"></h:message>
				
				<h:outputLabel value="#{resources['addEditUser.field.label.country']}" for="country" />
				<h:selectOneListbox id="country" value="#{visitBean.currentUser.countryId}" required="true" size="1">
					<f:selectItems value="#{addEditUserBean.countryItemArray}" />
				</h:selectOneListbox>
				<h:message for="country"></h:message>
				
				<h:outputLabel value="#{resources['addEditUser.field.label.phone']}" for="phone"/>
				<h:inputText id="phone" required="true" value="#{visitBean.currentUser.phone}">
					<f:validateLength  maximum="25"/>
				</h:inputText>
				<h:message for="phone"></h:message>
				
				<h:outputLabel value="e-mail" for="email" rendered="#{empty visitBean.currentUser.id}"/>
				<h:inputText id="email" required="true" value="#{visitBean.currentUser.email}" rendered="#{empty visitBean.currentUser.id}">
					<f:validateLength  maximum="100"/>
					<f:validator validatorId="isrp.EmailValidator"/>
				</h:inputText>
				<h:message for="email" rendered="#{empty visitBean.currentUser.id}"></h:message>
				
				<h:outputLabel value="#{resources['addEditUser.field.label.password']}" for="password" rendered="#{empty visitBean.currentUser.id}"/>
				<h:inputSecret id="password" required="true" value="#{visitBean.currentUser.password}" rendered="#{empty visitBean.currentUser.id}">
					<f:validateLength minimum="6" />
				</h:inputSecret>
				<h:message for="password" rendered="#{empty visitBean.currentUser.id}"></h:message>							
				
				<h:outputLabel value="#{resources['addEditUser.field.label.gender']}" for="gender"/>
				<h:selectOneRadio id="gender" value="#{visitBean.currentUser.gender}" required="true">
					<f:selectItems value="#{addEditUserBean.genderItemArray}" />
				</h:selectOneRadio>
				<h:message for="gender"></h:message>
				
				<h:outputLabel value="#{resources['addEditUser.field.label.accepted']}" for="accepted" rendered="#{empty visitBean.currentUser.id}"/>
			    <h:selectBooleanCheckbox id="accepted" immediate="true" onclick = "submit()" valueChangeListener="#{addEditUserBean.valueChangeListener}" binding="#{addEditUserBean.accepted}" rendered="#{empty visitBean.currentUser.id}"/>			    
			    <h:panelGroup rendered="#{empty visitBean.currentUser.id}"></h:panelGroup>
			    
				<h:commandButton value="#{resources['addEditUser.button.label.registration']}" action="#{addEditUserBean.registerNewUser}" rendered="#{empty visitBean.currentUser.id}" binding="#{addEditUserBean.downloadButton}" disabled="true"/>
				<h:commandButton value="#{resources['addEditUser.button.label.edit']}" action="#{addEditUserBean.editUser}" rendered="#{!empty visitBean.currentUser.id}" />					
				<h:panelGroup />
			</h:panelGrid>
		</h:form>
		</div>
		</div>
		<jsp:include page='includes/footer.jsp' />
	</f:view>
	</body>
	</html>
</jsp:root>