package isrp.model.service;

import java.util.List;

import isrp.hibernate.model.businessobject.User;
import isrp.hibernate.model.util.email.EmailConfiguration;

public interface UserService {

	User findById(int id);

	String getAdministratorEmail();

	void update(User user);

	User checkIfEmailExistInDB(String email);

	void registerNewAuthor(User user, EmailConfiguration emailConfiguration);

	void registerNewReviewer(User user, String passwordCopy,
			EmailConfiguration emailConfiguration);

	User authenticate(String email, String password);

	boolean delete(User user);

	void saveNewPassword(User user, String password,
			EmailConfiguration emailConfiguration);

	List<User> getReviewers();

	List<User> getAllUsers(String sortColumn);
}
