package isrp.viewbeans;

import isrp.hibernate.model.businessobject.User;
import isrp.model.service.UserService;
import isrp.utils.MessageUtil;
import java.io.Serializable;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.ListDataModel;

/**
 * Komponent wsparcia do obsugi listy uytkownikw.
 *
 */
public class UsersListBean implements Serializable{
	
	private static final long serialVersionUID = 1L;
	private ListDataModel usersList;
	private VisitBean visitBean;	
	private List<User> allUsers;
	private String sortColumn;
	private UtilBean utilBean;
	
	
	
	/** Tworzy tabele w sesji.	 */
	public UsersListBean() {
		//sprawdzenie czy utilBean nie jest nullem
		FacesContext ctx = FacesContext.getCurrentInstance();
		if (utilBean == null) utilBean=(UtilBean)ctx.getApplication().evaluateExpressionGet(ctx, "#{utilBean}", UtilBean.class);
		
		usersList = new ListDataModel(getAllUsers());		
		
	}

	
	
	public String deleteUser(){
		User user = (User) usersList.getRowData();
		UserService userSer = utilBean.getServiceLocator().getUserService();
		user = userSer.findById(user.getId());
		if (user==null){
			MessageUtil.addMessageToContext(FacesContext.getCurrentInstance(), "users.message.error.notExists");			
		}else{
			if (!userSer.delete(user)){
				MessageUtil.addMessageToContext(FacesContext.getCurrentInstance(), "users.message.error.deleteUser");
			}										
		}	
		usersList = new ListDataModel(getAllUsers());
		return null;
	}
	
	public void sort(ActionEvent actionEvent){
		//actionEvent.getComponent().getId()
		String id=actionEvent.getComponent().getId();
		if(id.equals("firstName")){
			sortColumn="firstName";
		}else if (id.equals("lastName")){
			sortColumn="lastName";
		}else if (id.equals("role")){
			sortColumn="role";
		}
		usersList = new ListDataModel(getAllUsers());
	}
	
	public String toEditUserPage(){
		User user = (User) usersList.getRowData();
		//making sure that paper stil exist
		UserService userSer = utilBean.getServiceLocator().getUserService();
		user = userSer.findById(user.getId());
		if (user==null){
			MessageUtil.addMessageToContext(FacesContext.getCurrentInstance(), "users.message.error.notExists");
			return null;
		}else{
			visitBean.setCurrentUser(user);
			return "edit_user_page";
		}	
	}
	
	public VisitBean getVisitBean() {
		return visitBean;
	}
	public void setVisitBean(VisitBean visitBean) {
		this.visitBean = visitBean;
	}
	/** Pobiera list z bazy danych.	 */
	public List<User> getAllUsers() {
		FacesContext ctx = FacesContext.getCurrentInstance();
		if (utilBean == null) utilBean=(UtilBean)ctx.getApplication().evaluateExpressionGet(ctx, "#{utilBean}", UtilBean.class);
		UserService userSer = utilBean.getServiceLocator().getUserService();
		allUsers = userSer.getAllUsers(sortColumn);		
		return allUsers;
	}
	public void setAllUsers(List<User> allUsers) {
		this.allUsers = allUsers;
	}
	public String getSortColumn() {
		return sortColumn;
	}
	public void setSortColumn(String sortColumn) {
		this.sortColumn = sortColumn;
	}

	public void setUtilBean(UtilBean utilBean) {
		this.utilBean = utilBean;
	}

	public UtilBean getUtilBean() {
		return utilBean;
	}

	public void setUsersList(ListDataModel usersList) {
		this.usersList = usersList;
	}

	public ListDataModel getUsersList() {
		if (usersList==null){
			usersList = new ListDataModel(getAllUsers());
		}
		return usersList;
	}
	
	
}
