package various.uicomponents;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;

/**
 * Kod przykadowego komponentu realizujcego funkcjonalno rozwijanego zestawu 
 * pl wejciowych - fieldset (patrz rozdzial 5.1).
 *
 */
public class ComboFieldset extends UIComponentBase{
	
	public static final String COMPONENT_TYPE="uicomponents.ComboFieldset";
	public static final String COMPONENT_FAMILY="uicomponents.ComboFieldset";
	public static final String CSS_STYLE="background-color:white;border:none;text-decoration:blink;";
	public static final String ROLL_SYMBOL="+";
	public static final String UNROLL_SYMBOL="-";
	private boolean rolled;
	private String legend;
	
	
	
	public String getLegend() {
		return legend;
	}


	public void setLegend(String legend) {
		this.legend = legend;
	}


	public String getFamily() {
		return COMPONENT_FAMILY;
	}


	public ComboFieldset() {
		super();
		setRendererType(null);
	}


	@Override
	public void restoreState(FacesContext context, Object state) {
		Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        setRolled((Boolean)values[1]);
        setLegend((String) values[2]);
	}


	@Override
	public Object saveState(FacesContext context) {
		Object[] values = new Object[3];
        values[0] = super.saveState(context);
        values[1] = isRolled();
        values[2] = getLegend();
        return values;
	}


	@Override
	public void encodeBegin(FacesContext context) throws IOException {
		  if (!isRendered()) {
	            return;
	        }
		  String clientId = getClientId(context);
	        ResponseWriter writer = context.getResponseWriter();     
	    	             
	       writer.startElement("fieldset", this);
	       writer.writeAttribute("id", clientId, null);
	        writer.startElement("legend", this);
	        if (getLegend()!=null ) writer.write(getLegend());
	       encodeButton(writer, clientId);
	       
	        writer.endElement("legend");	

	    }
//	
	private void encodeButton(ResponseWriter writer, String clientId)
	 throws IOException {
	 String value=rolled?ROLL_SYMBOL:UNROLL_SYMBOL;	
	 writer.startElement("input", this);
	 writer.writeAttribute("style", CSS_STYLE, null);
	 writer.writeAttribute("type", "submit", null);
	 writer.writeAttribute("name", clientId+value, null);
	 writer.writeAttribute("value", value, null);
	 writer.endElement("input");
	 }
//
//	@Override
	public void encodeChildren(FacesContext context) throws IOException {
		super.encodeChildren(context);
	
	
	}
//
//
	@Override
	public void encodeEnd(FacesContext context) throws IOException {
		 ResponseWriter writer = context.getResponseWriter();     
	        writer.endElement("fieldset");   
	        writer.writeText("dddddddddddddd", null);
	        writer.flush();
	}


	@Override
	public void decode(FacesContext context) {
				Map<String, String> requestMap = context.getExternalContext().getRequestParameterMap();
				String clientId = getClientId(context);
			    if (requestMap.containsKey(clientId + UNROLL_SYMBOL)) rolled = true;
				 else rolled = false;
			    FacesEvent action= new ActionEvent(this);
			    FacesEvent event= new ValueChangeEvent(this,clientId + UNROLL_SYMBOL , clientId + ROLL_SYMBOL);
			    this.queueEvent(event);
			    this.queueEvent(action);
				}


	@Override
	public boolean getRendersChildren() {
		return rolled;
	}


	public void setRolled(boolean rolled) {
		this.rolled = rolled;
	}


	public boolean isRolled() {
		return rolled;
	}

}
