/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule.model;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.myfaces.custom.schedule.model.ScheduleEntry;
import org.apache.myfaces.custom.schedule.util.ScheduleUtil;

public class DefaultScheduleEntry
implements Serializable,
ScheduleEntry {
    private static final long serialVersionUID = 1L;
    private Date endTime;
    private Date startTime;
    private String description;
    private String id;
    private String subtitle;
    private String title;
    private boolean allDay;
    private TimeZone timeZone;

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        if (this.endTime == null) {
            this.endTime = new Date();
        }
        if (this.isAllDay()) {
            Date truncated = ScheduleUtil.truncate(this.endTime, this.getTimeZone());
            Calendar cal = ScheduleUtil.getCalendarInstance(truncated, this.getTimeZone());
            cal.add(14, -1);
            truncated = cal.getTime();
            if (!truncated.equals(this.endTime)) {
                cal.add(5, 1);
            }
            return cal.getTime();
        }
        return this.endTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        if (this.startTime == null) {
            this.startTime = new Date();
        }
        if (this.isAllDay()) {
            return ScheduleUtil.truncate(this.startTime, this.getTimeZone());
        }
        return this.startTime;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isAllDay() {
        return this.allDay;
    }

    public void setAllDay(boolean allDay) {
        this.allDay = allDay;
    }
}

