/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.Resource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.AjaxBehaviorListener;
import javax.faces.event.MethodExpressionActionListener;
import javax.faces.view.facelets.FaceletContext;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Utils;

public final class Components {
    private static final String ERROR_INVALID_PARENT = "Component '%s' must have a parent of type '%s', but it cannot be found.";
    private static final String ERROR_INVALID_DIRECT_PARENT = "Component '%s' must have a direct parent of type '%s', but it cannot be found.";
    private static final String ERROR_CHILDREN_DISALLOWED = "Component '%s' must have no children. Encountered children of types '%s'.";

    private Components() {
    }

    public static UIComponent getCurrentComponent() {
        return UIComponent.getCurrentComponent((FacesContext)FacesContext.getCurrentInstance());
    }

    public static <T> T getAttribute(UIComponent component, String name) {
        return (T)component.getAttributes().get(name);
    }

    public static <T extends UIComponent> T findComponent(String clientId) {
        return (T)FacesContext.getCurrentInstance().getViewRoot().findComponent(clientId);
    }

    public static <T extends UIComponent> T findComponentRelatively(UIComponent component, String clientId) {
        if (Utils.isEmpty(clientId)) {
            return null;
        }
        T result = Components.findComponentInParents(component, clientId);
        if (result == null) {
            result = Components.findComponentInChildren((UIComponent)Faces.getViewRoot(), clientId);
        }
        return result;
    }

    public static <T extends UIComponent> T findComponentInParents(UIComponent component, String clientId) {
        if (Utils.isEmpty(clientId)) {
            return null;
        }
        UIComponent parent = component;
        while (parent != null) {
            UIComponent result = null;
            if (parent instanceof NamingContainer) {
                try {
                    result = parent.findComponent(clientId);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
            }
            if (result != null) {
                return (T)result;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static <T extends UIComponent> T findComponentInChildren(UIComponent component, String clientId) {
        if (Utils.isEmpty(clientId)) {
            return null;
        }
        for (UIComponent child : component.getChildren()) {
            Object result = null;
            if (child instanceof NamingContainer) {
                try {
                    result = child.findComponent(clientId);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
            }
            if (result == null) {
                result = Components.findComponentInChildren(child, clientId);
            }
            if (result == null) continue;
            return (T)result;
        }
        return null;
    }

    public static <T extends UIComponent> List<T> findComponentsInChildren(UIComponent component, Class<T> type) {
        ArrayList components = new ArrayList();
        Components.findComponentsInChildren(component, type, components);
        return components;
    }

    private static <T extends UIComponent> void findComponentsInChildren(UIComponent component, Class<T> type, List<T> matches) {
        for (UIComponent child : component.getChildren()) {
            if (type.isInstance(child)) {
                matches.add(child);
            }
            Components.findComponentsInChildren(child, type, matches);
        }
    }

    public static <T extends UIComponent> T getClosestParent(UIComponent component, Class<T> parentType) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !parentType.isInstance(parent); parent = parent.getParent()) {
        }
        return (T)((UIComponent)parentType.cast(parent));
    }

    public static boolean shouldVisitSkipIteration(VisitContext context) {
        try {
            return context.getHints().contains(VisitHint.valueOf((String)"SKIP_ITERATION"));
        }
        catch (IllegalArgumentException e) {
            return context.getFacesContext().getAttributes().get("javax.faces.visit.SKIP_ITERATION") == Boolean.TRUE;
        }
    }

    public static void includeFacelet(UIComponent parent, String path) throws IOException {
        Faces.getFaceletContext().includeFacelet(parent, path);
    }

    public static UIComponent includeCompositeComponent(UIComponent parent, String libraryName, String resourceName, String id) {
        FacesContext context = Faces.getContext();
        Application application = context.getApplication();
        FaceletContext faceletContext = Faces.getFaceletContext();
        Resource resource = application.getResourceHandler().createResource(resourceName, libraryName);
        UIComponent composite = application.createComponent(context, resource);
        composite.setId(id);
        UIComponent implementation = application.createComponent("javax.faces.Panel");
        implementation.setRendererType("javax.faces.Group");
        composite.getFacets().put("javax.faces.component.COMPOSITE_FACET_NAME", implementation);
        parent.getChildren().add(composite);
        parent.pushComponentToEL(context, composite);
        try {
            faceletContext.includeFacelet(implementation, resource.getURL());
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            parent.popComponentFromEL(context);
        }
        return composite;
    }

    public static UIForm getCurrentForm() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!facesContext.isPostback()) {
            return null;
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        for (String name : facesContext.getExternalContext().getRequestParameterMap().keySet()) {
            UIForm form;
            if (name.startsWith("javax.faces.")) continue;
            UIComponent component = Components.findComponentIgnoringIAE(viewRoot, name);
            if (component instanceof UIForm) {
                return (UIForm)component;
            }
            if (component == null || (form = Components.getClosestParent(component, UIForm.class)) == null) continue;
            return form;
        }
        return null;
    }

    public static UICommand getCurrentCommand() {
        UIComponent component;
        String source;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!facesContext.isPostback()) {
            return null;
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (facesContext.getPartialViewContext().isAjaxRequest() && (source = (String)params.get("javax.faces.source")) != null && (component = Components.findComponentIgnoringIAE(viewRoot, source)) instanceof UICommand) {
            return (UICommand)component;
        }
        for (String name : params.keySet()) {
            UIComponent component2;
            if (name.startsWith("javax.faces.") || !((component2 = Components.findComponentIgnoringIAE(viewRoot, name)) instanceof UICommand)) continue;
            return (UICommand)component2;
        }
        return null;
    }

    public static boolean isEditable(UIInput input) {
        return input.isRendered() && !Boolean.TRUE.equals(input.getAttributes().get("disabled")) && !Boolean.TRUE.equals(input.getAttributes().get("readonly"));
    }

    public static String getLabel(UIComponent input) {
        String label = Components.getOptionalLabel(input);
        return label != null ? label : input.getClientId();
    }

    public static String getOptionalLabel(UIComponent input) {
        ValueExpression labelExpression;
        Object label = input.getAttributes().get("label");
        if (Utils.isEmpty(label) && (labelExpression = input.getValueExpression("label")) != null) {
            label = labelExpression.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return label != null ? label.toString() : null;
    }

    public static <T> T getValue(EditableValueHolder component) {
        Object submittedValue = component.getSubmittedValue();
        return (T)(submittedValue != null ? submittedValue : component.getLocalValue());
    }

    public static <T> T getImmediateValue(UIInput input) {
        if (input.isValid() && input.getSubmittedValue() != null) {
            input.validate(FacesContext.getCurrentInstance());
        }
        return (T)(input.isLocalValueSet() ? input.getValue() : null);
    }

    public static boolean hasSubmittedValue(EditableValueHolder component) {
        return !Utils.isEmpty(component.getSubmittedValue());
    }

    public static boolean hasInvokedSubmit(UIComponent component) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context.isPostback()) {
            String clientId = component.getClientId(context);
            Map params = context.getExternalContext().getRequestParameterMap();
            if (context.getPartialViewContext().isAjaxRequest()) {
                return clientId.equals(params.get("javax.faces.source"));
            }
            return component instanceof UICommand && params.get(clientId) != null;
        }
        return false;
    }

    public static ValueExpression createValueExpression(String expression, Class<?> type) {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), expression, type);
    }

    public static MethodExpression createMethodExpression(String expression, Class<?> returnType, Class<?> ... parameterTypes) {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getApplication().getExpressionFactory().createMethodExpression(context.getELContext(), expression, returnType, (Class[])parameterTypes);
    }

    public static MethodExpression createVoidMethodExpression(String expression, Class<?> ... parameterTypes) {
        return Components.createMethodExpression(expression, Void.class, parameterTypes);
    }

    public static MethodExpressionActionListener createActionListenerMethodExpression(String expression) {
        return new MethodExpressionActionListener(Components.createVoidMethodExpression(expression, ActionEvent.class));
    }

    public static AjaxBehavior createAjaxBehavior(String expression) {
        FacesContext context = FacesContext.getCurrentInstance();
        AjaxBehavior behavior = (AjaxBehavior)context.getApplication().createBehavior("javax.faces.behavior.Ajax");
        final MethodExpression method = Components.createVoidMethodExpression(expression, AjaxBehaviorEvent.class);
        behavior.addAjaxBehaviorListener(new AjaxBehaviorListener(){

            public void processAjaxBehavior(AjaxBehaviorEvent event) throws AbortProcessingException {
                method.invoke(FacesContext.getCurrentInstance().getELContext(), new Object[]{event});
            }
        });
        return behavior;
    }

    public static <T extends UIComponent> void validateHasParent(UIComponent component, Class<T> parentType) throws IllegalArgumentException {
        if (Components.getClosestParent(component, parentType) == null) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_PARENT, component.getClass().getSimpleName(), parentType));
        }
    }

    public static <T extends UIComponent> void validateHasDirectParent(UIComponent component, Class<T> parentType) throws IllegalArgumentException {
        if (!parentType.isInstance(component.getParent())) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_DIRECT_PARENT, component.getClass().getSimpleName(), parentType));
        }
    }

    public static void validateHasNoChildren(UIComponent component) throws IllegalArgumentException {
        if (component.getChildCount() > 0) {
            StringBuilder childClassNames = new StringBuilder();
            for (UIComponent child : component.getChildren()) {
                if (childClassNames.length() > 0) {
                    childClassNames.append(", ");
                }
                childClassNames.append(child.getClass().getName());
            }
            throw new IllegalArgumentException(String.format(ERROR_CHILDREN_DISALLOWED, component.getClass().getSimpleName(), childClassNames));
        }
    }

    private static UIComponent findComponentIgnoringIAE(UIViewRoot viewRoot, String clientId) {
        try {
            return viewRoot.findComponent(clientId);
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }
}

