/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.omnifaces.resourcehandler.CombinedResourceInfo;
import org.omnifaces.resourcehandler.CombinedResourceInputStream;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Utils;

final class CombinedResource
extends Resource {
    private CombinedResourceInfo info;

    public CombinedResource(String name) {
        String[] resourcePathParts = name.split("\\.", 2)[0].split("/");
        String resourceId = resourcePathParts[resourcePathParts.length - 1];
        this.info = CombinedResourceInfo.get(resourceId);
        this.setResourceName(name);
        this.setLibraryName("omnifaces.combined");
        this.setContentType(Faces.getMimeType(name));
    }

    public CombinedResource(FacesContext context) {
        this(CombinedResource.getResourceName(context));
        if (this.info == null || this.info.getResources().isEmpty()) {
            throw new IllegalArgumentException();
        }
    }

    public String getRequestPath() {
        String mapping = Faces.getMapping();
        String path = "/javax.faces.resource/" + this.getResourceName();
        return Faces.getRequestContextPath() + (Faces.isPrefixMapping(mapping) ? mapping + path : path + mapping) + "?ln=" + "omnifaces.combined" + "&v=" + this.info.getLastModified() / 60000L;
    }

    public URL getURL() {
        try {
            return new URL(Faces.getRequestDomainURL() + this.getRequestPath());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getResponseHeaders() {
        HashMap<String, String> responseHeaders = new HashMap<String, String>(3);
        long lastModified = this.info.getLastModified();
        responseHeaders.put("Last-Modified", Utils.formatRFC1123(new Date(lastModified)));
        responseHeaders.put("Expires", Utils.formatRFC1123(new Date(System.currentTimeMillis() + this.info.getMaxAge())));
        responseHeaders.put("Etag", String.format("W/\"%d-%d\"", this.info.getContentLength(), lastModified));
        responseHeaders.put("Pragma", "");
        return responseHeaders;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.info.getResources().isEmpty()) {
            return new CombinedResourceInputStream(this.info.getResources());
        }
        return null;
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        String ifModifiedSince = (String)context.getExternalContext().getRequestHeaderMap().get("If-Modified-Since");
        if (ifModifiedSince != null) {
            try {
                return this.info.getLastModified() > Utils.parseRFC1123(ifModifiedSince).getTime();
            }
            catch (ParseException ignore) {
                return true;
            }
        }
        return true;
    }

    private static String getResourceName(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        String path = externalContext.getRequestPathInfo();
        if (path == null) {
            path = externalContext.getRequestServletPath();
            return path.substring(path.lastIndexOf(47) + 1, path.lastIndexOf(46));
        }
        return path.substring(path.lastIndexOf(47) + 1);
    }
}

