/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.omnifaces.io.ResettableBuffer;

public class ResettableBufferedOutputStream
extends OutputStream
implements ResettableBuffer {
    private OutputStream output;
    private ByteArrayOutputStream buffer;
    private int bufferSize;
    private int writtenBytes;

    public ResettableBufferedOutputStream(OutputStream output, int bufferSize) {
        this.output = output;
        this.bufferSize = bufferSize;
        this.buffer = new ByteArrayOutputStream(bufferSize);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        if (this.buffer != null) {
            if ((this.writtenBytes += length - offset) > this.bufferSize) {
                this.output.write(this.buffer.toByteArray());
                this.output.write(bytes, offset, length);
                this.buffer = null;
            } else {
                this.buffer.write(bytes, offset, length);
            }
        } else {
            this.output.write(bytes, offset, length);
        }
    }

    @Override
    public void reset() {
        this.buffer = new ByteArrayOutputStream(this.bufferSize);
        this.writtenBytes = 0;
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer == null) {
            this.output.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.buffer != null) {
            this.output.write(this.buffer.toByteArray());
            this.buffer = null;
        }
        this.output.close();
    }

    @Override
    public boolean isResettable() {
        return this.buffer != null;
    }
}

