/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.viewscope;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.omnifaces.application.ViewScopeProvider;
import org.omnifaces.cdi.BeanStorage;
import org.omnifaces.util.Faces;
import org.omnifaces.util.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import org.omnifaces.util.concurrentlinkedhashmap.EvictionListener;

@SessionScoped
public class ViewScopeManager
implements ViewScopeProvider,
Serializable {
    public static final String PARAM_NAME_MAX_ACTIVE_VIEW_SCOPES = "org.omnifaces.VIEW_SCOPE_MANAGER_MAX_ACTIVE_VIEW_SCOPES";
    public static final String PARAM_NAME_MOJARRA_NUMBER_OF_VIEWS = "com.sun.faces.numberOfLogicalViews";
    public static final String PARAM_NAME_MYFACES_NUMBER_OF_VIEWS = "org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION";
    public static final int DEFAULT_MAX_ACTIVE_VIEW_SCOPES = 20;
    private static final long serialVersionUID = 42L;
    private static final String[] PARAM_NAMES_MAX_ACTIVE_VIEW_SCOPES = new String[]{"org.omnifaces.VIEW_SCOPE_MANAGER_MAX_ACTIVE_VIEW_SCOPES", "com.sun.faces.numberOfLogicalViews", "org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION"};
    private static final int DEFAULT_BEANS_PER_VIEW_SCOPE = 3;
    private static final String ERROR_MAX_ACTIVE_VIEW_SCOPES = "The '%s' init param must be a number. Encountered an invalid value of '%s'.";
    private static Integer maxActiveViewScopes;
    private ConcurrentMap<UUID, BeanStorage> activeViewScopes;
    @Inject
    private BeanManager manager;

    @PostConstruct
    public void postConstructSession() {
        this.activeViewScopes = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(this.getMaxActiveViewScopes()).listener(new BeanStorageEvictionListener()).build();
    }

    public <T> T createBean(Contextual<T> type, CreationalContext<T> context) {
        return ((BeanStorage)this.activeViewScopes.get(this.getBeanStorageId(true))).createBean(type, context);
    }

    public <T> T getBean(Contextual<T> type) {
        return ((BeanStorage)this.activeViewScopes.get(this.getBeanStorageId(true))).getBean(type, this.manager);
    }

    @Override
    public void preDestroyView() {
        BeanStorage storage = (BeanStorage)this.activeViewScopes.remove(this.getBeanStorageId(false));
        if (storage != null) {
            storage.destroyBeans();
        }
    }

    @PreDestroy
    public void preDestroySession() {
        for (BeanStorage storage : this.activeViewScopes.values()) {
            storage.destroyBeans();
        }
    }

    private int getMaxActiveViewScopes() {
        if (maxActiveViewScopes != null) {
            return maxActiveViewScopes;
        }
        for (String name : PARAM_NAMES_MAX_ACTIVE_VIEW_SCOPES) {
            String value = Faces.getInitParameter(name);
            if (value == null) continue;
            if (value.matches("[0-9]+")) {
                maxActiveViewScopes = Integer.valueOf(value);
                return maxActiveViewScopes;
            }
            throw new IllegalArgumentException(String.format(ERROR_MAX_ACTIVE_VIEW_SCOPES, name, value));
        }
        maxActiveViewScopes = 20;
        return maxActiveViewScopes;
    }

    private UUID getBeanStorageId(boolean create) {
        UUID id = (UUID)Faces.getViewAttribute(ViewScopeManager.class.getName());
        if (id == null || this.activeViewScopes.get(id) == null) {
            id = UUID.randomUUID();
            if (create) {
                this.activeViewScopes.put(id, new BeanStorage(3));
            }
            Faces.setViewAttribute(ViewScopeManager.class.getName(), id);
        }
        return id;
    }

    private static final class BeanStorageEvictionListener
    implements EvictionListener<UUID, BeanStorage>,
    Serializable {
        private static final long serialVersionUID = 42L;

        private BeanStorageEvictionListener() {
        }

        @Override
        public void onEviction(UUID id, BeanStorage storage) {
            storage.destroyBeans();
        }
    }
}

