/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.accordionpanel;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.accordionpanel.AccordionPanel;
import org.primefaces.component.tabview.Tab;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class AccordionPanelRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        AccordionPanel acco = (AccordionPanel)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        String active = (String)params.get(acco.getClientId(context) + "_active");
        if (active != null) {
            if (this.isValueBlank(active)) {
                acco.setActiveIndex(null);
            } else {
                acco.setActiveIndex(active);
            }
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        AccordionPanel acco = (AccordionPanel)component;
        if (acco.isContentLoadRequest(context)) {
            String var = acco.getVar();
            String clientId = acco.getClientId(context);
            if (var == null) {
                String tabClientId = (String)params.get(clientId + "_newTab");
                Tab tabToLoad = acco.findTab(tabClientId);
                tabToLoad.encodeAll(context);
                tabToLoad.setLoaded(true);
            } else {
                int index = Integer.parseInt((String)params.get(clientId + "_tabindex"));
                acco.setRowIndex(index);
                ((UIComponent)acco.getChildren().get(0)).encodeAll(context);
                acco.setRowIndex(-1);
            }
        } else {
            this.encodeMarkup(context, acco);
            this.encodeScript(context, acco);
        }
    }

    protected void encodeMarkup(FacesContext context, AccordionPanel acco) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = acco.getClientId(context);
        String widgetVar = acco.resolveWidgetVar();
        String styleClass = acco.getStyleClass();
        String string = styleClass = styleClass == null ? "ui-accordion ui-widget ui-helper-reset ui-hidden-container" : "ui-accordion ui-widget ui-helper-reset ui-hidden-container " + styleClass;
        if (ComponentUtils.isRTL(context, acco)) {
            styleClass = styleClass + " ui-accordion-rtl";
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (acco.getStyle() != null) {
            writer.writeAttribute("style", (Object)acco.getStyle(), null);
        }
        writer.writeAttribute("role", (Object)"tablist", null);
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        this.encodeTabs(context, acco);
        this.encodeStateHolder(context, acco);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, AccordionPanel acco) throws IOException {
        String clientId = acco.getClientId(context);
        boolean multiple = acco.isMultiple();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("AccordionPanel", acco.resolveWidgetVar(), clientId);
        if (acco.isDynamic()) {
            wb.attr("dynamic", true).attr("cache", acco.isCache());
        }
        wb.attr("multiple", multiple, false).callback("onTabChange", "function(panel)", acco.getOnTabChange()).callback("onTabShow", "function(panel)", acco.getOnTabShow());
        this.encodeClientBehaviors(context, acco);
        wb.finish();
    }

    protected void encodeStateHolder(FacesContext context, AccordionPanel accordionPanel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = accordionPanel.getClientId(context);
        String stateHolderId = clientId + "_active";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)stateHolderId, null);
        writer.writeAttribute("name", (Object)stateHolderId, null);
        writer.writeAttribute("value", (Object)accordionPanel.getActiveIndex(), null);
        writer.endElement("input");
    }

    protected void encodeTabs(FacesContext context, AccordionPanel acco) throws IOException {
        boolean dynamic = acco.isDynamic();
        String var = acco.getVar();
        List<String> activeIndexes = Arrays.asList(acco.getActiveIndex().split(","));
        boolean rtl = acco.getDir().equalsIgnoreCase("rtl");
        if (var == null) {
            int i = 0;
            for (UIComponent child : acco.getChildren()) {
                if (!child.isRendered() || !(child instanceof Tab)) continue;
                boolean active = activeIndexes.indexOf(Integer.toString(i)) != -1;
                this.encodeTab(context, (Tab)child, active, dynamic, rtl);
                ++i;
            }
        } else {
            int dataCount = acco.getRowCount();
            Tab tab = (Tab)((Object)acco.getChildren().get(0));
            for (int i = 0; i < dataCount; ++i) {
                acco.setRowIndex(i);
                boolean active = activeIndexes.indexOf(Integer.toString(i)) != -1;
                this.encodeTab(context, tab, active, dynamic, rtl);
            }
            acco.setRowIndex(-1);
        }
    }

    protected void encodeTab(FacesContext context, Tab tab, boolean active, boolean dynamic, boolean rtl) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String headerClass = active ? "ui-accordion-header ui-helper-reset ui-state-default ui-state-active ui-corner-top" : "ui-accordion-header ui-helper-reset ui-state-default ui-corner-all";
        headerClass = tab.isDisabled() ? headerClass + " ui-state-disabled" : headerClass;
        String string = headerClass = tab.getTitleStyleClass() == null ? headerClass : headerClass + " " + tab.getTitleStyleClass();
        String iconClass = active ? "ui-icon ui-icon-triangle-1-s" : (rtl ? "ui-icon ui-icon-triangle-1-w" : "ui-icon ui-icon-triangle-1-e");
        String contentClass = active ? "ui-accordion-content ui-helper-reset ui-widget-content" : "ui-accordion-content ui-helper-reset ui-widget-content ui-helper-hidden";
        UIComponent titleFacet = tab.getFacet("title");
        writer.startElement("h3", null);
        writer.writeAttribute("class", (Object)headerClass, null);
        writer.writeAttribute("role", (Object)"tab", null);
        writer.writeAttribute("aria-expanded", (Object)String.valueOf(active), null);
        if (tab.getTitleStyle() != null) {
            writer.writeAttribute("style", (Object)tab.getTitleStyle(), null);
        }
        if (tab.getTitletip() != null) {
            writer.writeAttribute("title", (Object)tab.getTitletip(), null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        if (titleFacet == null) {
            writer.write(tab.getTitle());
        } else {
            titleFacet.encodeAll(context);
        }
        writer.endElement("a");
        writer.endElement("h3");
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)tab.getClientId(context), null);
        writer.writeAttribute("class", (Object)contentClass, null);
        writer.writeAttribute("role", (Object)"tabpanel", null);
        writer.writeAttribute("aria-hidden", (Object)String.valueOf(!active), null);
        if (dynamic) {
            if (active) {
                tab.encodeAll(context);
                tab.setLoaded(true);
            }
        } else {
            tab.encodeAll(context);
        }
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

