/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util.selectitems;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.omnifaces.util.Utils;
import org.omnifaces.util.selectitems.SelectItemsCollector;

public final class SelectItemsUtils {
    private SelectItemsUtils() {
    }

    public static Object findValueByStringConversion(FacesContext context, UIComponent component, String value, Converter converter) {
        return SelectItemsUtils.findValueByStringConversion(context, component, SelectItemsCollector.collectFromParent(context, component).iterator(), value, converter);
    }

    private static Object findValueByStringConversion(FacesContext context, UIComponent component, Iterator<SelectItem> items, String value, Converter converter) {
        while (items.hasNext()) {
            SelectItem item = items.next();
            if (item instanceof SelectItemGroup) {
                Object object;
                Object[] subitems = ((SelectItemGroup)item).getSelectItems();
                if (Utils.isEmpty(subitems) || (object = SelectItemsUtils.findValueByStringConversion(context, component, new ArrayIterator((SelectItem[])subitems), value, converter)) == null) continue;
                return object;
            }
            if (item.isNoSelectionOption()) continue;
            Object itemValue = item.getValue();
            String convertedItemValue = converter.getAsString(context, component, itemValue);
            if (!(value == null ? convertedItemValue == null : value.equals(convertedItemValue))) continue;
            return itemValue;
        }
        return null;
    }

    public static List<Object> collectAllValuesFromSelectItems(FacesContext context, UIComponent component) {
        ArrayList<Object> values = new ArrayList<Object>();
        SelectItemsUtils.collect(SelectItemsCollector.collectFromParent(context, component).iterator(), values);
        return values;
    }

    private static void collect(Iterator<SelectItem> items, List<Object> values) {
        while (items.hasNext()) {
            SelectItem item = items.next();
            if (item instanceof SelectItemGroup) {
                Object[] subitems = ((SelectItemGroup)item).getSelectItems();
                if (Utils.isEmpty(subitems)) continue;
                SelectItemsUtils.collect(new ArrayIterator((SelectItem[])subitems), values);
                continue;
            }
            if (item.isNoSelectionOption()) continue;
            values.add(item.getValue());
        }
    }

    static class ArrayIterator
    implements Iterator<SelectItem> {
        private SelectItem[] items;
        private int index = 0;

        public ArrayIterator(SelectItem[] items) {
            this.items = items;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.items.length;
        }

        @Override
        public SelectItem next() {
            try {
                return this.items[this.index++];
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

