/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.renderer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;
import javax.faces.render.Renderer;
import org.omnifaces.component.messages.OmniMessages;
import org.omnifaces.util.Components;
import org.omnifaces.util.Messages;
import org.omnifaces.util.Renderers;
import org.omnifaces.util.Utils;

@FacesRenderer(componentFamily="javax.faces.Messages", rendererType="org.omnifaces.Messages")
public class MessagesRenderer
extends Renderer {
    public static final String RENDERER_TYPE = "org.omnifaces.Messages";
    private static final Map<FacesMessage.Severity, String> SEVERITY_NAMES = MessagesRenderer.createSeverityNames();

    private static final Map<FacesMessage.Severity, String> createSeverityNames() {
        HashMap<FacesMessage.Severity, String> severityNames = new HashMap<FacesMessage.Severity, String>();
        severityNames.put(FacesMessage.SEVERITY_INFO, "info");
        severityNames.put(FacesMessage.SEVERITY_WARN, "warn");
        severityNames.put(FacesMessage.SEVERITY_ERROR, "error");
        severityNames.put(FacesMessage.SEVERITY_FATAL, "fatal");
        return Collections.unmodifiableMap(severityNames);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        OmniMessages omniMessages = (OmniMessages)component;
        List<FacesMessage> messages = this.getMessages(context, omniMessages);
        if (!Utils.isEmpty(omniMessages.getVar()) && omniMessages.getChildCount() > 0) {
            this.encodeMessagesRepeater(context, omniMessages, messages);
        } else if (messages.isEmpty()) {
            this.encodeEmptyMessages(context, omniMessages);
        } else {
            String message = omniMessages.getMessage();
            if (!Utils.isEmpty(message)) {
                messages = Arrays.asList(Messages.createInfo(message, new Object[0]));
            }
            this.encodeMessages(context, omniMessages, messages, "table".equals(omniMessages.getLayout()));
        }
    }

    protected List<FacesMessage> getMessages(FacesContext context, OmniMessages component) {
        String forClientIds = component.getFor();
        if (forClientIds == null) {
            return component.isGlobalOnly() ? context.getMessageList(null) : context.getMessageList();
        }
        ArrayList<FacesMessage> messages = new ArrayList<FacesMessage>();
        for (String forClientId : forClientIds.split("\\s+")) {
            Object forComponent = Components.findComponentRelatively((UIComponent)component, forClientId);
            if (forComponent == null) continue;
            messages.addAll(context.getMessageList(forComponent.getClientId(context)));
            if (forComponent instanceof UIInput) continue;
            for (UIInput child : Components.findComponentsInChildren(forComponent, UIInput.class)) {
                messages.addAll(context.getMessageList(child.getClientId(context)));
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeMessagesRepeater(FacesContext context, OmniMessages component, List<FacesMessage> messages) throws IOException {
        String var = component.getVar();
        Map requestMap = context.getExternalContext().getRequestMap();
        Object originalVar = requestMap.get(var);
        try {
            for (FacesMessage message : messages) {
                if (message.isRendered() && !component.isRedisplay()) continue;
                requestMap.put(var, message);
                for (UIComponent child : component.getChildren()) {
                    child.encodeAll(context);
                }
                message.rendered();
            }
        }
        finally {
            if (originalVar != null) {
                requestMap.put(var, originalVar);
            } else {
                requestMap.remove(var);
            }
        }
    }

    protected void encodeEmptyMessages(FacesContext context, OmniMessages component) throws IOException {
        String id = component.getId();
        if (id != null && !id.equals("javax_faces_developmentstage_messages")) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("div", (UIComponent)component);
            Renderers.writeAttribute(writer, "id", (Object)component.getClientId(context));
            writer.endElement("div");
        }
    }

    protected void encodeMessages(FacesContext context, OmniMessages component, List<FacesMessage> messages, boolean table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement(table ? "table" : "ul", (UIComponent)component);
        Renderers.writeAttribute(writer, "id", (Object)component.getClientId(context));
        Renderers.writeAttribute(writer, (UIComponent)component, "styleClass", "class");
        Renderers.writeAttributes(writer, (UIComponent)component, "style", "title", "lang", "dir");
        boolean showSummary = component.isShowSummary();
        boolean showDetail = component.isShowDetail();
        boolean escape = component.isEscape();
        boolean tooltip = component.isTooltip() && Utils.isEmpty(component.getTitle());
        for (FacesMessage message : messages) {
            if (message.isRendered() && !component.isRedisplay()) continue;
            writer.startElement(table ? "tr" : "li", (UIComponent)component);
            String severityName = SEVERITY_NAMES.get(message.getSeverity());
            Renderers.writeAttribute(writer, (UIComponent)component, severityName + "Style", "style");
            Renderers.writeAttribute(writer, (UIComponent)component, severityName + "Class", "class", "styleClass");
            if (table) {
                writer.startElement("td", (UIComponent)component);
            }
            String summary = Utils.coalesce(message.getSummary(), "");
            String detail = Utils.coalesce(message.getDetail(), summary);
            if (tooltip) {
                Renderers.writeAttribute(writer, "title", (Object)detail);
            }
            if (showSummary) {
                Renderers.writeText(writer, (UIComponent)component, summary, escape);
                if (showDetail) {
                    writer.write(" ");
                }
            }
            if (showDetail) {
                Renderers.writeText(writer, (UIComponent)component, detail, escape);
            }
            message.rendered();
            if (table) {
                writer.endElement("td");
            }
            writer.endElement(table ? "tr" : "li");
        }
        writer.endElement(table ? "table" : "ul");
    }
}

