/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.script;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.faces.FacesException;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ListenerFor;
import javax.faces.event.ListenersFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.omnifaces.component.script.ScriptFamily;
import org.omnifaces.util.Ajax;
import org.omnifaces.util.Events;

@FacesComponent(value="org.omnifaces.component.script.OnloadScript")
@ListenersFor(value={@ListenerFor(systemEventClass=PostAddToViewEvent.class), @ListenerFor(systemEventClass=PostRestoreStateEvent.class)})
public class OnloadScript
extends ScriptFamily
implements SystemEventListener {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.script.OnloadScript";

    public boolean isListenerForSource(Object source) {
        return source instanceof OnloadScript || source instanceof UIViewRoot;
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        UIViewRoot view = context.getViewRoot();
        boolean ajaxRequest = context.getPartialViewContext().isAjaxRequest();
        if (event instanceof PostAddToViewEvent) {
            if (!ajaxRequest || !view.getComponentResources(context, "body").contains((Object)this)) {
                view.addComponentResource(context, (UIComponent)this, "body");
            }
        } else if (event instanceof PostRestoreStateEvent && ajaxRequest) {
            Events.subscribeToViewEvent(PreRenderViewEvent.class, this);
        }
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (!(event instanceof PreRenderViewEvent)) {
            return;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (!this.shouldEncodeOncomplete(context.getPartialViewContext())) {
            return;
        }
        this.pushComponentToEL(context, (UIComponent)this);
        StringWriter buffer = new StringWriter();
        ResponseWriter originalResponseWriter = context.getResponseWriter();
        String encoding = context.getExternalContext().getRequestCharacterEncoding();
        context.getExternalContext().setResponseCharacterEncoding(encoding);
        final ResponseWriter writer = context.getRenderKit().createResponseWriter((Writer)buffer, null, encoding);
        context.setResponseWriter((ResponseWriter)new ResponseWriterWrapper(){

            public void writeText(Object text, String property) throws IOException {
                writer.write(text.toString());
            }

            public ResponseWriter getWrapped() {
                return writer;
            }
        });
        try {
            this.encodeChildren(context);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            if (originalResponseWriter != null) {
                context.setResponseWriter(originalResponseWriter);
            }
        }
        this.popComponentFromEL(context);
        String script = buffer.toString().trim();
        if (!script.isEmpty()) {
            Ajax.oncomplete(script);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.shouldEncodeHtml(context.getPartialViewContext())) {
            return;
        }
        this.pushComponentToEL(context, (UIComponent)this);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", (UIComponent)this);
        writer.writeAttribute("type", (Object)"text/javascript", "type");
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (!this.shouldEncodeHtml(context.getPartialViewContext())) {
            return;
        }
        context.getResponseWriter().endElement("script");
        this.popComponentFromEL(context);
    }

    private boolean shouldEncodeHtml(PartialViewContext pvc) {
        return this.isRendered() && (!pvc.isAjaxRequest() || pvc.isRenderAll());
    }

    private boolean shouldEncodeOncomplete(PartialViewContext pvc) {
        return this.isRendered() && pvc.isAjaxRequest() && !pvc.isRenderAll();
    }
}

