/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.input;

import java.io.IOException;
import java.io.Serializable;
import javax.faces.application.Application;
import javax.faces.application.ApplicationWrapper;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextWrapper;
import org.omnifaces.taghandler.IgnoreValidationFailed;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.State;

@FacesComponent(value="org.omnifaces.component.input.Form")
public class Form
extends UIForm {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.input.Form";
    private final State state = new State(this.getStateHelper());

    public void processValidators(FacesContext context) {
        if (this.isIgnoreValidationFailed(context)) {
            super.processValidators((FacesContext)new IgnoreValidationFailedFacesContext(context));
        } else {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (this.isIgnoreValidationFailed(context)) {
            super.processUpdates((FacesContext)new IgnoreValidationFailedFacesContext(context));
        } else {
            super.processUpdates(context);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (this.isUseRequestURI().booleanValue()) {
            super.encodeBegin((FacesContext)new ActionURLDecorator(context, PropertyKeys.useRequestURI));
        } else if (this.isIncludeRequestParams().booleanValue()) {
            super.encodeBegin((FacesContext)new ActionURLDecorator(context, PropertyKeys.includeRequestParams));
        } else if (this.isIncludeViewParams().booleanValue()) {
            super.encodeBegin((FacesContext)new ActionURLDecorator(context, PropertyKeys.includeViewParams));
        } else {
            super.encodeBegin(context);
        }
    }

    private boolean isIgnoreValidationFailed(FacesContext context) {
        return context.getAttributes().get(IgnoreValidationFailed.class.getName()) == Boolean.TRUE;
    }

    public Boolean isIncludeViewParams() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.includeViewParams), Boolean.FALSE);
    }

    public void setIncludeViewParams(boolean includeViewParams) {
        this.state.put((Serializable)((Object)PropertyKeys.includeViewParams), includeViewParams);
    }

    public Boolean isIncludeRequestParams() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.includeRequestParams), Boolean.FALSE);
    }

    public void setIncludeRequestParams(boolean includeRequestParams) {
        this.state.put((Serializable)((Object)PropertyKeys.includeRequestParams), includeRequestParams);
    }

    public Boolean isUseRequestURI() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.useRequestURI), Boolean.FALSE);
    }

    public void setUseRequestURI(boolean useRequestURI) {
        this.state.put((Serializable)((Object)PropertyKeys.useRequestURI), useRequestURI);
    }

    static class ActionURLDecorator
    extends FacesContextWrapper {
        private final FacesContext facesContext;
        private final PropertyKeys type;

        public ActionURLDecorator(FacesContext facesContext, PropertyKeys type) {
            this.facesContext = facesContext;
            this.type = type;
        }

        public Application getApplication() {
            return new ApplicationWrapper(){
                private final Application application;
                {
                    this.application = ActionURLDecorator.super.getApplication();
                }

                public ViewHandler getViewHandler() {
                    final 1 outer = this;
                    return new ViewHandlerWrapper(){
                        private final ViewHandler viewHandler;
                        {
                            this.viewHandler = outer.getWrapped().getViewHandler();
                        }

                        public String getActionURL(FacesContext context, String viewId) {
                            if (ActionURLDecorator.this.type == PropertyKeys.useRequestURI) {
                                return FacesLocal.getRequestURIWithQueryString(context);
                            }
                            if (ActionURLDecorator.this.type == PropertyKeys.includeRequestParams) {
                                return context.getExternalContext().encodeBookmarkableURL(super.getActionURL(context, viewId), FacesLocal.getRequestQueryStringMap(context));
                            }
                            if (ActionURLDecorator.this.type == PropertyKeys.includeViewParams) {
                                return context.getExternalContext().encodeBookmarkableURL(super.getActionURL(context, viewId), FacesLocal.getViewParameterMap(context));
                            }
                            return super.getActionURL(context, viewId);
                        }

                        public ViewHandler getWrapped() {
                            return this.viewHandler;
                        }
                    };
                }

                public Application getWrapped() {
                    return this.application;
                }
            };
        }

        public FacesContext getWrapped() {
            return this.facesContext;
        }
    }

    static class IgnoreValidationFailedFacesContext
    extends FacesContextWrapper {
        private FacesContext wrapped;

        public IgnoreValidationFailedFacesContext(FacesContext wrapped) {
            this.wrapped = wrapped;
        }

        public void validationFailed() {
        }

        public void renderResponse() {
        }

        public FacesContext getWrapped() {
            return this.wrapped;
        }
    }

    static enum PropertyKeys {
        includeViewParams,
        includeRequestParams,
        useRequestURI;

    }
}

