/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.radiobutton;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.primefaces.component.radiobutton.RadioButton;
import org.primefaces.component.selectoneradio.SelectOneRadio;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;

public class RadioButtonRenderer
extends InputRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        RadioButton radioButton = (RadioButton)component;
        SelectOneRadio selectOneRadio = (SelectOneRadio)SearchExpressionFacade.resolveComponent(context, (UIComponent)radioButton, radioButton.getFor());
        this.encodeMarkup(context, radioButton, selectOneRadio);
    }

    protected void encodeMarkup(FacesContext context, RadioButton radio, SelectOneRadio selectOneRadio) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String masterClientId = selectOneRadio.getClientId(context);
        String inputId = selectOneRadio.getRadioButtonId(context);
        String clientId = radio.getClientId(context);
        boolean disabled = radio.isDisabled() || selectOneRadio.isDisabled();
        Converter converter = ComponentUtils.getConverter(context, (UIComponent)selectOneRadio);
        SelectItem selecItem = selectOneRadio.getSelectItems().get(radio.getItemIndex());
        Object itemValue = selecItem.getValue();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)selectOneRadio, converter, itemValue);
        Object value = selectOneRadio.getSubmittedValue();
        if (value == null) {
            value = selectOneRadio.getValue();
        }
        Class type = value == null ? String.class : value.getClass();
        Object coercedItemValue = this.coerceToModelType(context, itemValue, type);
        boolean selected = coercedItemValue != null && coercedItemValue.equals(value);
        String style = radio.getStyle();
        String defaultStyleClass = selectOneRadio.isPlain() ? "ui-radiobutton ui-radiobutton-native ui-widget" : "ui-radiobutton ui-widget";
        String styleClass = radio.getStyleClass();
        styleClass = styleClass == null ? defaultStyleClass : defaultStyleClass + " " + styleClass;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        this.encodeOptionInput(context, selectOneRadio, radio, inputId, masterClientId, selected, disabled, itemValueAsString);
        this.encodeOptionOutput(context, selected, disabled);
        writer.endElement("div");
    }

    protected void encodeOptionInput(FacesContext context, SelectOneRadio radio, RadioButton button, String id, String name, boolean checked, boolean disabled, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String tabindex = button.getTabindex();
        if (tabindex == null) {
            tabindex = radio.getTabindex();
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("value", (Object)value, null);
        if (tabindex != null) {
            writer.writeAttribute("tabindex", (Object)tabindex, null);
        }
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        StringBuilder onchangeBuilder = new StringBuilder();
        if (radio.getOnchange() != null) {
            onchangeBuilder.append(radio.getOnchange()).append(";");
        }
        if (button.getOnchange() != null) {
            onchangeBuilder.append(button.getOnchange()).append(";");
        }
        if (onchangeBuilder.length() > 0) {
            writer.writeAttribute("onchange", (Object)onchangeBuilder.toString(), null);
        }
        writer.endElement("input");
        writer.endElement("div");
    }

    protected void encodeOptionOutput(FacesContext context, boolean selected, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String boxClass = "ui-radiobutton-box ui-widget ui-corner-all ui-state-default";
        boxClass = selected ? boxClass + " ui-state-active" : boxClass;
        boxClass = disabled ? boxClass + " ui-state-disabled" : boxClass;
        String iconClass = "ui-radiobutton-icon";
        iconClass = selected ? iconClass + " " + "ui-icon ui-icon-bullet" : iconClass;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)boxClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("div");
    }
}

