/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.gmap;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.behavior.ajax.AjaxBehavior;
import org.primefaces.component.gmap.GMap;
import org.primefaces.component.gmap.GMapInfoWindow;
import org.primefaces.model.map.Circle;
import org.primefaces.model.map.LatLng;
import org.primefaces.model.map.MapModel;
import org.primefaces.model.map.Marker;
import org.primefaces.model.map.Polygon;
import org.primefaces.model.map.Polyline;
import org.primefaces.model.map.Rectangle;
import org.primefaces.renderkit.CoreRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMapRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        GMap map = (GMap)component;
        this.encodeMarkup(facesContext, map);
        this.encodeScript(facesContext, map);
    }

    protected void encodeMarkup(FacesContext facesContext, GMap map) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = map.getClientId();
        writer.startElement("div", (UIComponent)map);
        writer.writeAttribute("id", (Object)clientId, null);
        if (map.getStyle() != null) {
            writer.writeAttribute("style", (Object)map.getStyle(), null);
        }
        if (map.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)map.getStyleClass(), null);
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, GMap map) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = map.getClientId();
        String widgetVar = map.resolveWidgetVar();
        GMapInfoWindow infoWindow = map.getInfoWindow();
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('GMap','" + widgetVar + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",mapTypeId:google.maps.MapTypeId." + map.getType().toUpperCase());
        writer.write(",center:new google.maps.LatLng(" + map.getCenter() + ")");
        writer.write(",zoom:" + map.getZoom());
        if (!map.isFitBounds()) {
            writer.write(",fitBounds:false");
        }
        this.encodeOverlays(context, map);
        if (map.isDisableDefaultUI()) {
            writer.write(",disableDefaultUI:true");
        }
        if (!map.isNavigationControl()) {
            writer.write(",navigationControl:false");
        }
        if (!map.isMapTypeControl()) {
            writer.write(",mapTypeControl:false");
        }
        if (map.isStreetView()) {
            writer.write(",streetViewControl:true");
        }
        if (!map.isDraggable()) {
            writer.write(",draggable:false");
        }
        if (map.isDisableDoubleClickZoom()) {
            writer.write(",disableDoubleClickZoom:true");
        }
        if (map.getOnPointClick() != null) {
            writer.write(",onPointClick:function(event) {" + map.getOnPointClick() + ";}");
        }
        if (infoWindow != null) {
            Map behaviorEvents = map.getClientBehaviors();
            List overlaySelectBehaviors = (List)behaviorEvents.get("overlaySelect");
            for (ClientBehavior clientBehavior : overlaySelectBehaviors) {
                ((AjaxBehavior)clientBehavior).setOnsuccess("PF('" + widgetVar + "').openWindow(data)");
            }
        }
        this.encodeClientBehaviors(context, map);
        writer.write("});});");
        this.endScript(writer);
    }

    protected void encodeOverlays(FacesContext context, GMap map) throws IOException {
        GMapInfoWindow infoWindow;
        MapModel model = map.getModel();
        ResponseWriter writer = context.getResponseWriter();
        if (model != null) {
            if (!model.getMarkers().isEmpty()) {
                this.encodeMarkers(context, map);
            }
            if (!model.getPolylines().isEmpty()) {
                this.encodePolylines(context, map);
            }
            if (!model.getPolygons().isEmpty()) {
                this.encodePolygons(context, map);
            }
            if (!model.getCircles().isEmpty()) {
                this.encodeCircles(context, map);
            }
            if (!model.getRectangles().isEmpty()) {
                this.encodeRectangles(context, map);
            }
        }
        if ((infoWindow = map.getInfoWindow()) != null) {
            writer.write(",infoWindow: new google.maps.InfoWindow({");
            writer.write("id:'" + infoWindow.getClientId(context) + "'");
            writer.write("})");
        }
    }

    protected void encodeMarkers(FacesContext context, GMap map) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MapModel model = map.getModel();
        writer.write(",markers:[");
        Iterator<Marker> iterator = model.getMarkers().iterator();
        while (iterator.hasNext()) {
            Marker marker = iterator.next();
            this.encodeMarker(context, marker);
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
    }

    protected void encodeMarker(FacesContext context, Marker marker) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write("new google.maps.Marker({");
        writer.write("position:new google.maps.LatLng(" + marker.getLatlng().getLat() + ", " + marker.getLatlng().getLng() + ")");
        writer.write(",id:'" + marker.getId() + "'");
        if (marker.getTitle() != null) {
            writer.write(",title:\"" + this.escapeText(marker.getTitle()) + "\"");
        }
        if (marker.getIcon() != null) {
            writer.write(",icon:'" + marker.getIcon() + "'");
        }
        if (marker.getShadow() != null) {
            writer.write(",shadow:'" + marker.getShadow() + "'");
        }
        if (marker.getCursor() != null) {
            writer.write(",cursor:'" + marker.getCursor() + "'");
        }
        if (marker.isDraggable()) {
            writer.write(",draggable: true");
        }
        if (!marker.isVisible()) {
            writer.write(",visible: false");
        }
        if (marker.isFlat()) {
            writer.write(",flat: true");
        }
        if (marker.getZindex() > Integer.MIN_VALUE) {
            writer.write(",zIndex:" + marker.getZindex());
        }
        writer.write("})");
    }

    protected void encodePolylines(FacesContext context, GMap map) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MapModel model = map.getModel();
        writer.write(",polylines:[");
        Iterator<Polyline> lines = model.getPolylines().iterator();
        while (lines.hasNext()) {
            Polyline polyline = lines.next();
            writer.write("new google.maps.Polyline({");
            writer.write("id:'" + polyline.getId() + "'");
            this.encodePaths(context, polyline.getPaths());
            writer.write(",strokeOpacity:" + polyline.getStrokeOpacity());
            writer.write(",strokeWeight:" + polyline.getStrokeWeight());
            if (polyline.getStrokeColor() != null) {
                writer.write(",strokeColor:'" + polyline.getStrokeColor() + "'");
            }
            if (polyline.getZindex() > Integer.MIN_VALUE) {
                writer.write(",zIndex:" + polyline.getZindex());
            }
            writer.write("})");
            if (!lines.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
    }

    protected void encodePolygons(FacesContext context, GMap map) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MapModel model = map.getModel();
        writer.write(",polygons:[");
        Iterator<Polygon> polygons = model.getPolygons().iterator();
        while (polygons.hasNext()) {
            Polygon polygon = polygons.next();
            writer.write("new google.maps.Polygon({");
            writer.write("id:'" + polygon.getId() + "'");
            this.encodePaths(context, polygon.getPaths());
            writer.write(",strokeOpacity:" + polygon.getStrokeOpacity());
            writer.write(",strokeWeight:" + polygon.getStrokeWeight());
            writer.write(",fillOpacity:" + polygon.getFillOpacity());
            if (polygon.getStrokeColor() != null) {
                writer.write(",strokeColor:'" + polygon.getStrokeColor() + "'");
            }
            if (polygon.getFillColor() != null) {
                writer.write(",fillColor:'" + polygon.getFillColor() + "'");
            }
            if (polygon.getZindex() > Integer.MIN_VALUE) {
                writer.write(",zIndex:" + polygon.getZindex());
            }
            writer.write("})");
            if (!polygons.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
    }

    protected void encodeCircles(FacesContext context, GMap map) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MapModel model = map.getModel();
        writer.write(",circles:[");
        Iterator<Circle> circles = model.getCircles().iterator();
        while (circles.hasNext()) {
            Circle circle = circles.next();
            writer.write("new google.maps.Circle({");
            writer.write("id:'" + circle.getId() + "'");
            writer.write(",center:new google.maps.LatLng(" + circle.getCenter().getLat() + ", " + circle.getCenter().getLng() + ")");
            writer.write(",radius:" + circle.getRadius());
            writer.write(",strokeOpacity:" + circle.getStrokeOpacity());
            writer.write(",strokeWeight:" + circle.getStrokeWeight());
            writer.write(",fillOpacity:" + circle.getFillOpacity());
            if (circle.getStrokeColor() != null) {
                writer.write(",strokeColor:'" + circle.getStrokeColor() + "'");
            }
            if (circle.getFillColor() != null) {
                writer.write(",fillColor:'" + circle.getFillColor() + "'");
            }
            if (circle.getZindex() > Integer.MIN_VALUE) {
                writer.write(",zIndex:" + circle.getZindex());
            }
            writer.write("})");
            if (!circles.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
    }

    protected void encodeRectangles(FacesContext context, GMap map) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MapModel model = map.getModel();
        writer.write(",rectangles:[");
        Iterator<Rectangle> rectangles = model.getRectangles().iterator();
        while (rectangles.hasNext()) {
            Rectangle rectangle = rectangles.next();
            writer.write("new google.maps.Rectangle({");
            writer.write("id:'" + rectangle.getId() + "'");
            LatLng ne = rectangle.getBounds().getNorthEast();
            LatLng sw = rectangle.getBounds().getSouthWest();
            writer.write(",bounds:new google.maps.LatLngBounds( new google.maps.LatLng(" + ne.getLat() + "," + ne.getLng() + "), new google.maps.LatLng(" + sw.getLat() + "," + sw.getLng() + "))");
            writer.write(",strokeOpacity:" + rectangle.getStrokeOpacity());
            writer.write(",strokeWeight:" + rectangle.getStrokeWeight());
            writer.write(",fillOpacity:" + rectangle.getFillOpacity());
            if (rectangle.getStrokeColor() != null) {
                writer.write(",strokeColor:'" + rectangle.getStrokeColor() + "'");
            }
            if (rectangle.getFillColor() != null) {
                writer.write(",fillColor:'" + rectangle.getFillColor() + "'");
            }
            if (rectangle.getZindex() > Integer.MIN_VALUE) {
                writer.write(",zIndex:" + rectangle.getZindex());
            }
            writer.write("})");
            if (!rectangles.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
    }

    protected void encodePaths(FacesContext context, List<LatLng> paths) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write(",path:[");
        Iterator<LatLng> coords = paths.iterator();
        while (coords.hasNext()) {
            LatLng coord = coords.next();
            writer.write("new google.maps.LatLng(" + coord.getLat() + ", " + coord.getLng() + ")");
            if (!coords.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

