/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.tree;

import java.io.IOException;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.omnifaces.component.tree.Tree;
import org.omnifaces.component.tree.TreeFamily;
import org.omnifaces.model.tree.TreeModel;
import org.omnifaces.util.Callback;
import org.omnifaces.util.Components;

@FacesComponent(value="org.omnifaces.component.tree.TreeNodeItem")
public class TreeNodeItem
extends TreeFamily {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.tree.TreeNodeItem";
    private static final String ERROR_NESTING_DISALLOWED = "Nesting TreeNodeItem components is disallowed. Use TreeNode instead to markup specific levels.";

    @Override
    protected void validateHierarchy() {
        Components.validateHasParent((UIComponent)this, Tree.class);
        if (Components.getClosestParent((UIComponent)this, TreeNodeItem.class) != null) {
            throw new IllegalArgumentException(ERROR_NESTING_DISALLOWED);
        }
    }

    public void encodeAll(FacesContext context) throws IOException {
        this.encodeChildren(context);
    }

    @Override
    protected void process(final FacesContext context, final PhaseId phaseId) {
        if (this.getChildCount() == 0) {
            return;
        }
        this.process(context, new Callback.ReturningWithArgument<Void, Tree>(){

            @Override
            public Void invoke(Tree tree) {
                if (tree.getCurrentModelNode() != null) {
                    for (TreeModel childModelNode : tree.getCurrentModelNode()) {
                        tree.setCurrentModelNode(context, childModelNode);
                        if (!TreeNodeItem.this.isRendered()) continue;
                        TreeNodeItem.this.processSuper(context, phaseId);
                    }
                }
                return null;
            }
        });
    }

    public boolean visitTree(final VisitContext context, final VisitCallback callback) {
        if (Components.shouldVisitSkipIteration(context)) {
            return super.visitTree(context, callback);
        }
        if (!this.isVisitable(context) || this.getChildCount() == 0) {
            return false;
        }
        return this.process(context.getFacesContext(), new Callback.ReturningWithArgument<Boolean, Tree>(){

            @Override
            public Boolean invoke(Tree tree) {
                if (tree.getCurrentModelNode() != null) {
                    for (TreeModel childModelNode : tree.getCurrentModelNode()) {
                        tree.setCurrentModelNode(context.getFacesContext(), childModelNode);
                        if (!TreeNodeItem.super.visitTree(context, callback)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R process(FacesContext context, Callback.ReturningWithArgument<R, Tree> callback) {
        Tree tree = Components.getClosestParent((UIComponent)this, Tree.class);
        TreeModel originalModelNode = tree.getCurrentModelNode();
        try {
            R r = callback.invoke(tree);
            return r;
        }
        finally {
            tree.setCurrentModelNode(context, originalModelNode);
        }
    }
}

