/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.input.componentidparam;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;

public class ConditionalResponseWriter
extends ResponseWriterWrapper {
    private final ResponseWriter responseWriter;
    private final FacesContext facesContext;
    private final List<String> componentIds;
    private final List<String> clientIds;
    private final boolean renderChildren;
    private UIComponent lastComponent;
    private boolean lastRendered;
    private Map<String, Boolean> renderedIdCache = new HashMap<String, Boolean>();
    private Map<UIComponent, Boolean> renderedReferenceCache = new HashMap<UIComponent, Boolean>();

    public ConditionalResponseWriter(ResponseWriter responseWriter, FacesContext facesContext, List<String> componentIds, List<String> clientIds, boolean renderChildren) {
        this.responseWriter = responseWriter;
        this.facesContext = facesContext;
        this.componentIds = componentIds;
        this.clientIds = clientIds;
        this.renderChildren = renderChildren;
    }

    public void endCDATA() throws IOException {
        if (this.isForRenderedComponent()) {
            super.endCDATA();
        }
    }

    public void endElement(String name) throws IOException {
        if (this.isForRenderedComponent()) {
            super.endElement(name);
        }
    }

    public void endDocument() throws IOException {
        if (this.isForRenderedComponent()) {
            super.endDocument();
        }
    }

    public void startCDATA() throws IOException {
        if (this.isForRenderedComponent()) {
            super.startCDATA();
        }
    }

    public void startDocument() throws IOException {
        if (this.isForRenderedComponent()) {
            super.startDocument();
        }
    }

    public void startElement(String name, UIComponent component) throws IOException {
        if (this.isForRenderedComponent()) {
            super.startElement(name, component);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.isForRenderedComponent()) {
            super.write(cbuf, off, len);
        }
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (this.isForRenderedComponent()) {
            super.writeAttribute(name, value, property);
        }
    }

    public void writeComment(Object comment) throws IOException {
        if (this.isForRenderedComponent()) {
            super.writeComment(comment);
        }
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        if (this.isForRenderedComponent()) {
            super.writeText(text, off, len);
        }
    }

    public void writeText(Object text, String property) throws IOException {
        if (this.isForRenderedComponent()) {
            super.writeText(text, property);
        }
    }

    public void writeText(Object text, UIComponent component, String property) throws IOException {
        if (this.isForRenderedComponent()) {
            super.writeText(text, component, property);
        }
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (this.isForRenderedComponent()) {
            super.writeURIAttribute(name, value, property);
        }
    }

    public Writer append(char c) throws IOException {
        if (this.isForRenderedComponent()) {
            return super.append(c);
        }
        return this;
    }

    public Writer append(CharSequence csq) throws IOException {
        if (this.isForRenderedComponent()) {
            return super.append(csq);
        }
        return this;
    }

    public Writer append(CharSequence csq, int start, int end) throws IOException {
        if (this.isForRenderedComponent()) {
            return super.append(csq, start, end);
        }
        return this;
    }

    public void write(char[] cbuf) throws IOException {
        super.write(cbuf);
    }

    public void write(int c) throws IOException {
        if (this.isForRenderedComponent()) {
            super.write(c);
        }
    }

    public void write(String str) throws IOException {
        if (this.isForRenderedComponent()) {
            super.write(str);
        }
    }

    public void write(String str, int off, int len) throws IOException {
        if (this.isForRenderedComponent()) {
            super.write(str, off, len);
        }
    }

    private boolean isForRenderedComponent() {
        UIComponent currentComponent = UIComponent.getCurrentComponent((FacesContext)this.facesContext);
        if (this.lastComponent == currentComponent) {
            return this.lastRendered;
        }
        this.lastComponent = currentComponent;
        if (this.renderedIdCache.containsKey(currentComponent.getClientId())) {
            this.lastRendered = this.renderedIdCache.get(currentComponent.getClientId());
            return this.lastRendered;
        }
        boolean bl = this.lastRendered = this.componentIds.contains(currentComponent.getId()) || this.clientIds.contains(currentComponent.getClientId());
        if (this.renderChildren) {
            if (!this.lastRendered) {
                for (UIComponent parent = currentComponent.getParent(); parent != null; parent = parent.getParent()) {
                    if (this.renderedIdCache.containsKey(parent.getClientId())) {
                        this.lastRendered = this.renderedIdCache.get(parent.getClientId());
                    } else {
                        if (!this.renderedReferenceCache.containsKey(parent)) continue;
                        this.lastRendered = this.renderedReferenceCache.get(parent);
                    }
                    break;
                }
            } else {
                this.renderedReferenceCache.put(currentComponent, this.lastRendered);
            }
            this.renderedIdCache.put(currentComponent.getClientId(), this.lastRendered);
        }
        return this.lastRendered;
    }

    public ResponseWriter getWrapped() {
        return this.responseWriter;
    }
}

