/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.el.functions;

public final class Arrays {
    private static final String ERROR_INVALID_ARRAY_SIZE = "The array size must be at least 0.";

    private Arrays() {
    }

    public static Object[] createArray(int size) {
        if (size < 0) {
            throw new IllegalArgumentException(ERROR_INVALID_ARRAY_SIZE);
        }
        return new Object[size];
    }

    public static Integer[] createIntegerArray(int begin, int end) {
        int direction = begin < end ? 1 : (begin > end ? -1 : 0);
        int size = Math.abs(end - begin) + 1;
        Integer[] array = new Integer[size];
        for (int i = 0; i < size; ++i) {
            array[i] = begin + i * direction;
        }
        return array;
    }

    public static boolean contains(Object[] array, Object item) {
        if (array == null || item == null) {
            return false;
        }
        for (Object object : array) {
            if (object == null || !object.toString().equals(item.toString())) continue;
            return true;
        }
        return false;
    }
}

