/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.output.cache;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.omnifaces.component.output.cache.Cache;
import org.omnifaces.component.output.cache.CacheEntry;

public abstract class TimeToLiveCache
implements Cache {
    private static final long serialVersionUID = 6637500586287606410L;
    private final Integer defaultTimeToLive;
    private Map<String, CacheEntry> cacheStore;

    public TimeToLiveCache(Integer defaultTimeToLive) {
        this.defaultTimeToLive = defaultTimeToLive;
    }

    @Override
    public String get(String key) {
        CacheEntry entry = this.cacheStore.get(key);
        if (entry != null) {
            if (entry.isValid()) {
                return entry.getValue();
            }
            this.cacheStore.remove(key);
        }
        return null;
    }

    @Override
    public void put(String key, String value) {
        if (this.defaultTimeToLive != null) {
            this.put(key, value, this.defaultTimeToLive);
        } else {
            this.put(key, value, -1);
        }
    }

    @Override
    public void put(String key, String value, int timeToLive) {
        CacheEntry entry = this.cacheStore.get(key);
        if (entry == null || !entry.isValid()) {
            this.cacheStore.put(key, new CacheEntry(value, this.timeToLiveToDate(timeToLive)));
        } else {
            entry.setValue(value);
            entry.setValidTill(this.timeToLiveToDate(timeToLive));
        }
    }

    @Override
    public void putAttribute(String key, String name, Object value, int timeToLive) {
        CacheEntry entry = this.cacheStore.get(key);
        if (entry == null || !entry.isValid()) {
            entry = new CacheEntry(null, this.timeToLiveToDate(timeToLive));
            this.cacheStore.put(key, entry);
        }
        entry.getAttributes().put(name, value);
    }

    @Override
    public Object getAttribute(String key, String name) {
        CacheEntry entry = this.cacheStore.get(key);
        if (entry != null) {
            if (entry.isValid()) {
                return entry.getAttributes().get(name);
            }
            this.cacheStore.remove(key);
        }
        return null;
    }

    @Override
    public void remove(String key) {
        this.cacheStore.remove(key);
    }

    protected void setCacheStore(Map<String, CacheEntry> cacheStore) {
        this.cacheStore = cacheStore;
    }

    private Date timeToLiveToDate(int timeToLive) {
        if (timeToLive != -1) {
            return new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeToLive));
        }
        return null;
    }
}

